/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.jms;

import jakarta.jms.ConnectionFactory;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.jms.JmsHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ArtemisAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="jms")
public class JmsHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<JmsHealthIndicator, ConnectionFactory> {
    public JmsHealthContributorAutoConfiguration() {
        super(JmsHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"jmsHealthIndicator", "jmsHealthContributor"})
    public HealthContributor jmsHealthContributor(Map<String, ConnectionFactory> connectionFactories) {
        return (HealthContributor)this.createContributor(connectionFactories);
    }
}

