/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Tag;
import io.micrometer.observation.Observation;
import org.springframework.boot.actuate.metrics.web.reactive.client.WebClientExchangeTagsProvider;
import org.springframework.core.Conventions;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientRequestObservationContext;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;

class ClientObservationConventionAdapter
implements ClientRequestObservationConvention {
    private static final String URI_TEMPLATE_ATTRIBUTE = Conventions.getQualifiedAttributeName(WebClient.class, (String)"uriTemplate");
    private final String metricName;
    private final WebClientExchangeTagsProvider tagsProvider;

    ClientObservationConventionAdapter(String metricName, WebClientExchangeTagsProvider tagsProvider) {
        this.metricName = metricName;
        this.tagsProvider = tagsProvider;
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ClientRequestObservationContext;
    }

    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        ClientRequest request = context.getRequest();
        if (request == null) {
            request = ((ClientRequest.Builder)context.getCarrier()).attribute(URI_TEMPLATE_ATTRIBUTE, (Object)context.getUriTemplate()).build();
        }
        Iterable tags = this.tagsProvider.tags(request, (ClientResponse)context.getResponse(), context.getError());
        return KeyValues.of((Iterable)tags, Tag::getKey, Tag::getValue);
    }

    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.empty();
    }

    public String getName() {
        return this.metricName;
    }
}

