/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.otlp;

import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnEnabledTracing
@ConditionalOnClass(value={OtelTracer.class, SdkTracerProvider.class, OpenTelemetry.class, OtlpHttpSpanExporter.class})
@EnableConfigurationProperties(value={OtlpProperties.class})
public class OtlpAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OtlpHttpSpanExporter.class}, type={"io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter"})
    OtlpHttpSpanExporter otlpHttpSpanExporter(OtlpProperties properties) {
        OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder().setEndpoint(properties.getEndpoint()).setTimeout(properties.getTimeout()).setCompression(properties.getCompression().name().toLowerCase());
        for (Map.Entry<String, String> header : properties.getHeaders().entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        return builder.build();
    }
}

