/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.jms;

import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationContext;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.Message;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.jms.core.JmsTemplate;

@AutoConfiguration(after={JmsAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnBean(value={ObservationRegistry.class, JmsTemplate.class})
@ConditionalOnClass(value={Observation.class, Message.class, JmsTemplate.class, JmsPublishObservationContext.class})
public class JmsTemplateObservationAutoConfiguration {
    @Bean
    static JmsTemplateObservationPostProcessor jmsTemplateObservationPostProcessor(ObjectProvider<ObservationRegistry> observationRegistry) {
        return new JmsTemplateObservationPostProcessor(observationRegistry);
    }

    static class JmsTemplateObservationPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<ObservationRegistry> observationRegistry;

        JmsTemplateObservationPostProcessor(ObjectProvider<ObservationRegistry> observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof JmsTemplate) {
                JmsTemplate jmsTemplate = (JmsTemplate)bean;
                this.observationRegistry.ifAvailable(arg_0 -> ((JmsTemplate)jmsTemplate).setObservationRegistry(arg_0));
            }
            return bean;
        }
    }
}

