/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import brave.internal.propagation.StringPropagationAdapter;
import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.brave.bridge.W3CPropagation;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.boot.actuate.autoconfigure.tracing.LocalBaggageFields;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;

class CompositePropagationFactory
extends Propagation.Factory {
    private final PropagationFactories injectors;
    private final PropagationFactories extractors;
    private final CompositePropagation propagation;

    CompositePropagationFactory(Collection<Propagation.Factory> injectorFactories, Collection<Propagation.Factory> extractorFactories) {
        this.injectors = new PropagationFactories(injectorFactories);
        this.extractors = new PropagationFactories(extractorFactories);
        this.propagation = new CompositePropagation(this.injectors, this.extractors);
    }

    Stream<Propagation.Factory> getInjectors() {
        return this.injectors.stream();
    }

    public boolean supportsJoin() {
        return this.injectors.supportsJoin() && this.extractors.supportsJoin();
    }

    public boolean requires128BitTraceId() {
        return this.injectors.requires128BitTraceId() || this.extractors.requires128BitTraceId();
    }

    public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
        return StringPropagationAdapter.create((Propagation)this.propagation, keyFactory);
    }

    public TraceContext decorate(TraceContext context) {
        return Stream.concat(this.injectors.stream(), this.extractors.stream()).map(factory -> factory.decorate(context)).filter(decorated -> decorated != context).findFirst().orElse(context);
    }

    static CompositePropagationFactory create(TracingProperties.Propagation properties) {
        return CompositePropagationFactory.create(properties, null, null);
    }

    static CompositePropagationFactory create(TracingProperties.Propagation properties, BaggageManager baggageManager, LocalBaggageFields localFields) {
        PropagationFactoryMapper mapper = new PropagationFactoryMapper(baggageManager, localFields);
        List<Propagation.Factory> injectors = properties.getEffectiveProducedTypes().stream().map(mapper::map).toList();
        List<Propagation.Factory> extractors = properties.getEffectiveConsumedTypes().stream().map(mapper::map).toList();
        return new CompositePropagationFactory(injectors, extractors);
    }

    private static class PropagationFactories {
        private final List<Propagation.Factory> factories;

        PropagationFactories(Collection<Propagation.Factory> factories) {
            this.factories = List.copyOf(factories);
        }

        boolean requires128BitTraceId() {
            return this.stream().anyMatch(Propagation.Factory::requires128BitTraceId);
        }

        boolean supportsJoin() {
            return this.stream().allMatch(Propagation.Factory::supportsJoin);
        }

        List<Propagation<String>> get() {
            return this.stream().map(Propagation.Factory::get).toList();
        }

        Stream<Propagation.Factory> stream() {
            return this.factories.stream();
        }
    }

    private static class CompositePropagation
    implements Propagation<String> {
        private final List<Propagation<String>> injectors;
        private final List<Propagation<String>> extractors;
        private final List<String> keys;

        CompositePropagation(PropagationFactories injectorFactories, PropagationFactories extractorFactories) {
            this.injectors = injectorFactories.get();
            this.extractors = extractorFactories.get();
            this.keys = Stream.concat(this.keys(this.injectors), this.keys(this.extractors)).distinct().toList();
        }

        private Stream<String> keys(List<Propagation<String>> propagations) {
            return propagations.stream().flatMap(propagation -> propagation.keys().stream());
        }

        public List<String> keys() {
            return this.keys;
        }

        public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
            return (traceContext, request) -> this.injectors.stream().map(propagation -> propagation.injector(setter)).forEach(injector -> injector.inject(traceContext, request));
        }

        public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
            return request -> this.extractors.stream().map(propagation -> propagation.extractor(getter)).map(extractor -> extractor.extract(request)).filter(Predicate.not(arg_0 -> ((TraceContextOrSamplingFlags)TraceContextOrSamplingFlags.EMPTY).equals(arg_0))).findFirst().orElse(TraceContextOrSamplingFlags.EMPTY);
        }
    }

    private static class PropagationFactoryMapper {
        private final BaggageManager baggageManager;
        private final LocalBaggageFields localFields;

        PropagationFactoryMapper(BaggageManager baggageManager, LocalBaggageFields localFields) {
            this.baggageManager = baggageManager;
            this.localFields = localFields != null ? localFields : LocalBaggageFields.empty();
        }

        Propagation.Factory map(TracingProperties.Propagation.PropagationType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case TracingProperties.Propagation.PropagationType.B3 -> this.b3Single();
                case TracingProperties.Propagation.PropagationType.B3_MULTI -> this.b3Multi();
                case TracingProperties.Propagation.PropagationType.W3C -> this.w3c();
            };
        }

        private Propagation.Factory b3Single() {
            return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE).build();
        }

        private Propagation.Factory b3Multi() {
            return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.MULTI).build();
        }

        private Propagation.Factory w3c() {
            if (this.baggageManager == null) {
                return new W3CPropagation();
            }
            return new W3CPropagation(this.baggageManager, this.localFields.asList());
        }
    }
}

