/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.prometheus;

import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusSimpleclientMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.function.SingletonSupplier;

@Deprecated(forRemoval=true, since="3.3.0")
@AutoConfiguration(before={PrometheusSimpleclientMetricsExportAutoConfiguration.class}, after={MicrometerTracingAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Tracer.class, SpanContextSupplier.class})
public class PrometheusSimpleclientExemplarsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    SpanContextSupplier spanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        return new LazyTracingSpanContextSupplier(tracerProvider);
    }

    static class LazyTracingSpanContextSupplier
    implements SpanContextSupplier {
        private final SingletonSupplier<Tracer> tracer = SingletonSupplier.of(() -> tracerProvider.getObject());

        LazyTracingSpanContextSupplier(ObjectProvider<Tracer> tracerProvider) {
        }

        public String getTraceId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().traceId() : null;
        }

        public String getSpanId() {
            Span currentSpan = this.currentSpan();
            return currentSpan != null ? currentSpan.context().spanId() : null;
        }

        public boolean isSampled() {
            Span currentSpan = this.currentSpan();
            if (currentSpan == null) {
                return false;
            }
            Boolean sampled = currentSpan.context().sampled();
            return sampled != null && sampled != false;
        }

        private Span currentSpan() {
            return ((Tracer)this.tracer.obtain()).currentSpan();
        }
    }
}

