/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.ssl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;

class SslMeterBinder
implements MeterBinder {
    private static final String CHAINS_METRIC_NAME = "ssl.chains";
    private static final String CHAIN_EXPIRY_METRIC_NAME = "ssl.chain.expiry";
    private final Clock clock;
    private final SslInfo sslInfo;
    private final BundleMetrics bundleMetrics = new BundleMetrics();

    SslMeterBinder(SslInfo sslInfo, SslBundles sslBundles) {
        this(sslInfo, sslBundles, Clock.systemDefaultZone());
    }

    SslMeterBinder(SslInfo sslInfo, SslBundles sslBundles, Clock clock) {
        this.clock = clock;
        this.sslInfo = sslInfo;
        sslBundles.addBundleRegisterHandler((bundleName, ignored) -> this.onBundleChange((String)bundleName));
        for (String bundleName2 : sslBundles.getBundleNames()) {
            sslBundles.addBundleUpdateHandler(bundleName2, ignored -> this.onBundleChange(bundleName2));
        }
    }

    private void onBundleChange(String bundleName) {
        SslInfo.BundleInfo bundle = this.sslInfo.getBundle(bundleName);
        this.bundleMetrics.updateBundle(bundle);
        for (MeterRegistry meterRegistry : this.bundleMetrics.getMeterRegistries()) {
            this.createOrUpdateBundleMetrics(meterRegistry, bundle);
        }
    }

    public void bindTo(MeterRegistry meterRegistry) {
        for (SslInfo.BundleInfo bundle : this.sslInfo.getBundles()) {
            this.createOrUpdateBundleMetrics(meterRegistry, bundle);
        }
        Gauge.builder((String)CHAINS_METRIC_NAME, () -> this.countChainsByStatus(SslInfo.CertificateValidityInfo.Status.VALID)).tag("status", "valid").register(meterRegistry);
        Gauge.builder((String)CHAINS_METRIC_NAME, () -> this.countChainsByStatus(SslInfo.CertificateValidityInfo.Status.EXPIRED)).tag("status", "expired").register(meterRegistry);
        Gauge.builder((String)CHAINS_METRIC_NAME, () -> this.countChainsByStatus(SslInfo.CertificateValidityInfo.Status.NOT_YET_VALID)).tag("status", "not-yet-valid").register(meterRegistry);
        Gauge.builder((String)CHAINS_METRIC_NAME, () -> this.countChainsByStatus(SslInfo.CertificateValidityInfo.Status.WILL_EXPIRE_SOON)).tag("status", "will-expire-soon").register(meterRegistry);
    }

    private void createOrUpdateBundleMetrics(MeterRegistry meterRegistry, SslInfo.BundleInfo bundle) {
        MultiGauge multiGauge = this.bundleMetrics.getGauge(bundle, meterRegistry);
        ArrayList<MultiGauge.Row<SslInfo.CertificateInfo>> rows = new ArrayList<MultiGauge.Row<SslInfo.CertificateInfo>>();
        for (SslInfo.CertificateChainInfo chain : bundle.getCertificateChains()) {
            MultiGauge.Row<SslInfo.CertificateInfo> row = this.createRowForChain(bundle, chain);
            if (row == null) continue;
            rows.add(row);
        }
        multiGauge.register(rows, true);
    }

    private MultiGauge.Row<SslInfo.CertificateInfo> createRowForChain(SslInfo.BundleInfo bundle, SslInfo.CertificateChainInfo chain) {
        SslInfo.CertificateInfo leastValidCertificate = chain.getCertificates().stream().min(Comparator.comparing(SslInfo.CertificateInfo::getValidityEnds)).orElse(null);
        if (leastValidCertificate == null) {
            return null;
        }
        Tags tags = Tags.of((String[])new String[]{"chain", chain.getAlias(), "bundle", bundle.getName(), "certificate", leastValidCertificate.getSerialNumber()});
        return MultiGauge.Row.of((Tags)tags, (Object)leastValidCertificate, this::getChainExpiry);
    }

    private long countChainsByStatus(SslInfo.CertificateValidityInfo.Status status) {
        long count = 0L;
        for (SslInfo.BundleInfo bundle : this.bundleMetrics.getBundles()) {
            for (SslInfo.CertificateChainInfo chain : bundle.getCertificateChains()) {
                if (this.getChainStatus(chain) != status) continue;
                ++count;
            }
        }
        return count;
    }

    private SslInfo.CertificateValidityInfo.Status getChainStatus(SslInfo.CertificateChainInfo chain) {
        EnumSet<SslInfo.CertificateValidityInfo.Status> statuses = EnumSet.noneOf(SslInfo.CertificateValidityInfo.Status.class);
        for (SslInfo.CertificateInfo certificate : chain.getCertificates()) {
            SslInfo.CertificateValidityInfo validity = certificate.getValidity();
            statuses.add(validity.getStatus());
        }
        if (statuses.contains(SslInfo.CertificateValidityInfo.Status.EXPIRED)) {
            return SslInfo.CertificateValidityInfo.Status.EXPIRED;
        }
        if (statuses.contains(SslInfo.CertificateValidityInfo.Status.NOT_YET_VALID)) {
            return SslInfo.CertificateValidityInfo.Status.NOT_YET_VALID;
        }
        if (statuses.contains(SslInfo.CertificateValidityInfo.Status.WILL_EXPIRE_SOON)) {
            return SslInfo.CertificateValidityInfo.Status.WILL_EXPIRE_SOON;
        }
        return statuses.isEmpty() ? null : SslInfo.CertificateValidityInfo.Status.VALID;
    }

    private long getChainExpiry(SslInfo.CertificateInfo certificate) {
        Duration valid = Duration.between(Instant.now(this.clock), certificate.getValidityEnds());
        return valid.get(ChronoUnit.SECONDS);
    }

    private static final class BundleMetrics {
        private final Map<String, Gauges> gauges = new ConcurrentHashMap<String, Gauges>();

        private BundleMetrics() {
        }

        MultiGauge getGauge(SslInfo.BundleInfo bundleInfo, MeterRegistry meterRegistry) {
            Gauges gauges = this.gauges.computeIfAbsent(bundleInfo.getName(), ignored -> Gauges.emptyGauges(bundleInfo));
            return gauges.getGauge(meterRegistry);
        }

        Collection<SslInfo.BundleInfo> getBundles() {
            ArrayList<SslInfo.BundleInfo> result = new ArrayList<SslInfo.BundleInfo>();
            for (Gauges metrics : this.gauges.values()) {
                result.add(metrics.bundle());
            }
            return result;
        }

        Collection<MeterRegistry> getMeterRegistries() {
            HashSet<MeterRegistry> result = new HashSet<MeterRegistry>();
            for (Gauges metrics : this.gauges.values()) {
                result.addAll(metrics.getMeterRegistries());
            }
            return result;
        }

        void updateBundle(SslInfo.BundleInfo bundle) {
            this.gauges.computeIfPresent(bundle.getName(), (key, oldValue) -> oldValue.withBundle(bundle));
        }

        private record Gauges(SslInfo.BundleInfo bundle, Map<MeterRegistry, MultiGauge> multiGauges) {
            MultiGauge getGauge(MeterRegistry meterRegistry) {
                return this.multiGauges.computeIfAbsent(meterRegistry, ignored -> this.createGauge(meterRegistry));
            }

            Gauges withBundle(SslInfo.BundleInfo bundle) {
                return new Gauges(bundle, this.multiGauges);
            }

            Set<MeterRegistry> getMeterRegistries() {
                return this.multiGauges.keySet();
            }

            private MultiGauge createGauge(MeterRegistry meterRegistry) {
                return MultiGauge.builder((String)SslMeterBinder.CHAIN_EXPIRY_METRIC_NAME).baseUnit("seconds").description("SSL chain expiry").register(meterRegistry);
            }

            static Gauges emptyGauges(SslInfo.BundleInfo bundle) {
                return new Gauges(bundle, new ConcurrentHashMap<MeterRegistry, MultiGauge>());
            }
        }
    }
}

