/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryWebEndpointDiscoverer;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryInfoEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryWebEndpointServletHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.TokenValidator;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ServletManagementContextAutoConfiguration;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.actuate.info.GitInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.actuate.info.InfoPropertiesInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.info.GitProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(after={ServletManagementContextAutoConfiguration.class, HealthEndpointAutoConfiguration.class, InfoEndpointAutoConfiguration.class})
@ConditionalOnBooleanProperty(name={"management.cloudfoundry.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={DispatcherServlet.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class CloudFoundryActuatorAutoConfiguration {
    private static final String BASE_PATH = "/cloudfoundryapplication";

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnBean(value={HealthEndpoint.class, HealthEndpointWebExtension.class})
    public CloudFoundryHealthEndpointWebExtension cloudFoundryHealthEndpointWebExtension(HealthEndpointWebExtension healthEndpointWebExtension) {
        return new CloudFoundryHealthEndpointWebExtension(healthEndpointWebExtension);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnBean(value={InfoEndpoint.class, GitProperties.class})
    public CloudFoundryInfoEndpointWebExtension cloudFoundryInfoEndpointWebExtension(GitProperties properties, ObjectProvider<InfoContributor> infoContributors) {
        List<InfoContributor> contributors = infoContributors.orderedStream().map(infoContributor -> infoContributor instanceof GitInfoContributor ? new GitInfoContributor(properties, InfoPropertiesInfoContributor.Mode.FULL) : infoContributor).toList();
        return new CloudFoundryInfoEndpointWebExtension(new InfoEndpoint(contributors));
    }

    @Bean
    public CloudFoundryWebEndpointServletHandlerMapping cloudFoundryWebEndpointServletHandlerMapping(ParameterValueMapper parameterMapper, EndpointMediaTypes endpointMediaTypes, RestTemplateBuilder restTemplateBuilder, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, ApplicationContext applicationContext) {
        CloudFoundryWebEndpointDiscoverer discoverer = new CloudFoundryWebEndpointDiscoverer(applicationContext, parameterMapper, endpointMediaTypes, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        CloudFoundrySecurityInterceptor securityInterceptor = this.getSecurityInterceptor(restTemplateBuilder, applicationContext.getEnvironment());
        Collection webEndpoints = discoverer.getEndpoints();
        ArrayList allEndpoints = new ArrayList();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new CloudFoundryWebEndpointServletHandlerMapping(new EndpointMapping(BASE_PATH), webEndpoints, endpointMediaTypes, this.getCorsConfiguration(), securityInterceptor, allEndpoints);
    }

    private CloudFoundrySecurityInterceptor getSecurityInterceptor(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        CloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(restTemplateBuilder, environment);
        TokenValidator tokenValidator = new TokenValidator(cloudfoundrySecurityService);
        return new CloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment.getProperty("vcap.application.application_id"));
    }

    private CloudFoundrySecurityService getCloudFoundrySecurityService(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        String cloudControllerUrl = environment.getProperty("vcap.application.cf_api");
        boolean skipSslValidation = (Boolean)environment.getProperty("management.cloudfoundry.skip-ssl-validation", Boolean.class, (Object)false);
        return cloudControllerUrl != null ? new CloudFoundrySecurityService(restTemplateBuilder, cloudControllerUrl, skipSslValidation) : null;
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    @ConditionalOnClass(value={WebSecurityCustomizer.class, WebSecurity.class})
    @Configuration(proxyBeanMethods=false)
    public static class IgnoredCloudFoundryPathsWebSecurityConfiguration {
        private static final int FILTER_CHAIN_ORDER = -1;

        @Bean
        @Order(value=-1)
        SecurityFilterChain cloudFoundrySecurityFilterChain(HttpSecurity http, CloudFoundryWebEndpointServletHandlerMapping handlerMapping) throws Exception {
            RequestMatcher cloudFoundryRequest = this.getRequestMatcher(handlerMapping);
            http.securityMatchers(matches -> matches.requestMatchers(new RequestMatcher[]{cloudFoundryRequest})).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).permitAll());
            return (SecurityFilterChain)http.build();
        }

        private RequestMatcher getRequestMatcher(CloudFoundryWebEndpointServletHandlerMapping handlerMapping) {
            PathMappedEndpoints endpoints = new PathMappedEndpoints(CloudFoundryActuatorAutoConfiguration.BASE_PATH, handlerMapping::getAllEndpoints);
            ArrayList<PathPatternRequestMatcher> matchers = new ArrayList<PathPatternRequestMatcher>();
            endpoints.getAllPaths().forEach(path -> matchers.add(this.pathMatcher(path + "/**")));
            matchers.add(this.pathMatcher(CloudFoundryActuatorAutoConfiguration.BASE_PATH));
            matchers.add(this.pathMatcher("/cloudfoundryapplication/"));
            return new OrRequestMatcher(matchers);
        }

        private PathPatternRequestMatcher pathMatcher(String path) {
            return PathPatternRequestMatcher.withDefaults().matcher(path);
        }
    }
}

