/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.otlp;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import java.util.Locale;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpGrpcSpanExporterBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpHttpSpanExporterBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingProperties;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.Transport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

class OtlpTracingConfigurations {
    OtlpTracingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OtlpGrpcSpanExporter.class, OtlpHttpSpanExporter.class})
    @ConditionalOnBean(value={OtlpTracingConnectionDetails.class})
    @ConditionalOnEnabledTracing(value="otlp")
    static class Exporters {
        Exporters() {
        }

        @Bean
        @ConditionalOnProperty(name={"management.otlp.tracing.transport"}, havingValue="http", matchIfMissing=true)
        OtlpHttpSpanExporter otlpHttpSpanExporter(OtlpTracingProperties properties, OtlpTracingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider, ObjectProvider<OtlpHttpSpanExporterBuilderCustomizer> customizers) {
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.HTTP)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.ROOT));
            properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
            meterProvider.ifAvailable(arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setMeterProvider(arg_0));
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        }

        @Bean
        @ConditionalOnProperty(name={"management.otlp.tracing.transport"}, havingValue="grpc")
        OtlpGrpcSpanExporter otlpGrpcSpanExporter(OtlpTracingProperties properties, OtlpTracingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider, ObjectProvider<OtlpGrpcSpanExporterBuilderCustomizer> customizers) {
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.GRPC)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.ROOT));
            properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
            meterProvider.ifAvailable(arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setMeterProvider(arg_0));
            customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConnectionDetails {
        ConnectionDetails() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"management.otlp.tracing.endpoint"})
        OtlpTracingConnectionDetails otlpTracingConnectionDetails(OtlpTracingProperties properties) {
            return new PropertiesOtlpTracingConnectionDetails(properties);
        }

        static class PropertiesOtlpTracingConnectionDetails
        implements OtlpTracingConnectionDetails {
            private final OtlpTracingProperties properties;

            PropertiesOtlpTracingConnectionDetails(OtlpTracingProperties properties) {
                this.properties = properties;
            }

            @Override
            public String getUrl(Transport transport) {
                Assert.state((transport == this.properties.getTransport() ? 1 : 0) != 0, (String)"Requested transport %s doesn't match configured transport %s".formatted(new Object[]{transport, this.properties.getTransport()}));
                return this.properties.getEndpoint();
            }
        }
    }
}

