/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.audit;

import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AbstractAuditListener;
import org.springframework.boot.actuate.audit.listener.AuditListener;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.boot.actuate.security.AuthenticationAuditListener;
import org.springframework.boot.actuate.security.AuthorizationAuditListener;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnBean(value={AuditEventRepository.class})
@ConditionalOnBooleanProperty(name={"management.auditevents.enabled"}, matchIfMissing=true)
public class AuditAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AbstractAuditListener.class})
    public AuditListener auditListener(AuditEventRepository auditEventRepository) {
        return new AuditListener(auditEventRepository);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.security.access.event.AbstractAuthorizationEvent"})
    static class AuthorizationAuditConfiguration {
        AuthorizationAuditConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractAuthorizationAuditListener.class})
        AuthorizationAuditListener authorizationAuditListener() {
            return new AuthorizationAuditListener();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.security.authentication.event.AbstractAuthenticationEvent"})
    static class AuthenticationAuditConfiguration {
        AuthenticationAuditConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AbstractAuthenticationAuditListener.class})
        AuthenticationAuditListener authenticationAuditListener() {
            return new AuthenticationAuditListener();
        }
    }
}

