/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class ManagementWebServerFactoryCustomizer<T extends ConfigurableWebServerFactory>
implements WebServerFactoryCustomizer<T>,
Ordered {
    private final ListableBeanFactory beanFactory;
    private final Class<? extends WebServerFactoryCustomizer<?>> @Nullable [] customizerClasses;

    public ManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.customizerClasses = null;
    }

    public int getOrder() {
        return 0;
    }

    public final void customize(T factory) {
        ManagementServerProperties managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
        if (this.customizerClasses != null) {
            this.customizeSameAsParentContext(factory);
        }
        factory.setErrorPages(Collections.emptySet());
        ServerProperties serverProperties = (ServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerProperties.class);
        this.customize(factory, managementServerProperties, serverProperties);
    }

    private void customizeSameAsParentContext(T factory) {
        ArrayList customizers = new ArrayList();
        Assert.state((this.customizerClasses != null ? 1 : 0) != 0, (String)"'customizerClasses' must not be null");
        for (Class<? extends WebServerFactoryCustomizer<?>> customizerClass : this.customizerClasses) {
            try {
                customizers.add((WebServerFactoryCustomizer)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, customizerClass));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        this.invokeCustomizers(factory, customizers);
    }

    private void invokeCustomizers(T factory, List<WebServerFactoryCustomizer<?>> customizers) {
        LambdaSafe.callbacks(WebServerFactoryCustomizer.class, customizers, factory, (Object[])new Object[0]).invoke(customizer -> customizer.customize((WebServerFactory)factory));
    }

    protected void customize(T factory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
        Integer port = managementServerProperties.getPort();
        Assert.state((port != null ? 1 : 0) != 0, (String)"'port' must not be null");
        factory.setPort(port.intValue());
        Ssl ssl = managementServerProperties.getSsl();
        if (ssl != null) {
            factory.setSsl(ssl);
        }
        factory.setServerHeader(serverProperties.getServerHeader());
        factory.setAddress(managementServerProperties.getAddress());
    }
}

