/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.MappingWebEndpointPathMapper;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.OperationFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.AdditionalPathsMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ExposableControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={EndpointAutoConfiguration.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={WebEndpointProperties.class})
public final class WebEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final WebEndpointProperties properties;

    WebEndpointAutoConfiguration(ApplicationContext applicationContext, WebEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    PathMapper webEndpointPathMapper() {
        return new MappingWebEndpointPathMapper(this.properties.getPathMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    EndpointMediaTypes endpointMediaTypes() {
        return EndpointMediaTypes.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean(value={WebEndpointsSupplier.class})
    WebEndpointDiscoverer webEndpointDiscoverer(ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<AdditionalPathsMapper> additionalPathsMappers, ObjectProvider<OperationInvokerAdvisor> invokerAdvisors, ObjectProvider<EndpointFilter<ExposableWebEndpoint>> endpointFilters, ObjectProvider<OperationFilter<WebOperation>> operationFilters) {
        return new WebEndpointDiscoverer(this.applicationContext, parameterValueMapper, endpointMediaTypes, endpointPathMappers.orderedStream().toList(), additionalPathsMappers.orderedStream().toList(), invokerAdvisors.orderedStream().toList(), endpointFilters.orderedStream().toList(), operationFilters.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean(value={ControllerEndpointsSupplier.class})
    ControllerEndpointDiscoverer controllerEndpointDiscoverer(ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<Collection<EndpointFilter<ExposableControllerEndpoint>>> filters) {
        return new ControllerEndpointDiscoverer(this.applicationContext, endpointPathMappers.orderedStream().toList(), (Collection)filters.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConditionalOnMissingBean
    PathMappedEndpoints pathMappedEndpoints(Collection<EndpointsSupplier<?>> endpointSuppliers) {
        String basePath = this.properties.getBasePath();
        PathMappedEndpoints pathMappedEndpoints = new PathMappedEndpoints(basePath, endpointSuppliers);
        if ((!StringUtils.hasText((String)basePath) || "/".equals(basePath)) && ManagementPortType.get(this.applicationContext.getEnvironment()) == ManagementPortType.SAME) {
            this.assertHasNoRootPaths(pathMappedEndpoints);
        }
        return pathMappedEndpoints;
    }

    private void assertHasNoRootPaths(PathMappedEndpoints endpoints) {
        for (PathMappedEndpoint endpoint : endpoints) {
            if (!(endpoint instanceof ExposableWebEndpoint)) continue;
            ExposableWebEndpoint webEndpoint = (ExposableWebEndpoint)endpoint;
            Assert.state((!this.isMappedToRootPath((PathMappedEndpoint)webEndpoint) ? 1 : 0) != 0, () -> "Management base path and the '" + String.valueOf(webEndpoint.getEndpointId()) + "' actuator endpoint are both mapped to '/' on the server port which will block access to other endpoints. Please use a different path for management endpoints or map them to a dedicated management port.");
        }
    }

    private boolean isMappedToRootPath(PathMappedEndpoint endpoint) {
        return endpoint.getRootPath().equals("/") || endpoint.getAdditionalPaths(WebServerNamespace.SERVER).contains("/");
    }

    @Bean
    IncludeExcludeEndpointFilter<ExposableWebEndpoint> webExposeExcludePropertyEndpointFilter() {
        WebEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new IncludeExcludeEndpointFilter<ExposableWebEndpoint>(ExposableWebEndpoint.class, exposure.getInclude(), exposure.getExclude(), EndpointExposure.WEB.getDefaultIncludes());
    }

    @Bean
    IncludeExcludeEndpointFilter<ExposableControllerEndpoint> controllerExposeExcludePropertyEndpointFilter() {
        WebEndpointProperties.Exposure exposure = this.properties.getExposure();
        return new IncludeExcludeEndpointFilter<ExposableControllerEndpoint>(ExposableControllerEndpoint.class, exposure.getInclude(), exposure.getExclude(), new String[0]);
    }

    @Bean
    OperationFilter<WebOperation> webAccessPropertiesOperationFilter(EndpointAccessResolver endpointAccessResolver) {
        return OperationFilter.byAccess((EndpointAccessResolver)endpointAccessResolver);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class WebEndpointServletConfiguration {
        WebEndpointServletConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ServletEndpointsSupplier.class})
        ServletEndpointDiscoverer servletEndpointDiscoverer(ApplicationContext applicationContext, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<EndpointFilter<ExposableServletEndpoint>> filters) {
            return new ServletEndpointDiscoverer(applicationContext, endpointPathMappers.orderedStream().toList(), filters.orderedStream().toList());
        }
    }
}

