/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="management", ignoreUnknownFields=false)
public class ManagementServerProperties
implements SecurityPrequisite {
    private static final String SECURITY_CHECK_CLASS = "org.springframework.security.config.http.SessionCreationPolicy";
    private Integer port;
    private InetAddress address;
    @NotNull
    private String contextPath = "";
    private final Security security = ManagementServerProperties.maybeCreateSecurity();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Security getSecurity() {
        return this.security;
    }

    private static Security maybeCreateSecurity() {
        if (ClassUtils.isPresent((String)SECURITY_CHECK_CLASS, null)) {
            return new Security();
        }
        return null;
    }

    public static class Security {
        private boolean enabled = true;
        private String role = "ADMIN";
        private SessionCreationPolicy sessions = SessionCreationPolicy.STATELESS;

        public SessionCreationPolicy getSessions() {
            return this.sessions;
        }

        public void setSessions(SessionCreationPolicy sessions) {
            this.sessions = sessions;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getRole() {
            return this.role;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

