/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.util.Assert;

public class VanillaPublicMetrics
implements PublicMetrics {
    private final MetricReader reader;

    public VanillaPublicMetrics(MetricReader reader) {
        Assert.notNull((Object)reader, (String)"MetricReader must not be null");
        this.reader = reader;
    }

    @Override
    public Collection<Metric<?>> metrics() {
        LinkedHashSet result = new LinkedHashSet();
        for (Metric<?> metric : this.reader.findAll()) {
            result.add(metric);
        }
        result.add(new Metric<Long>("mem", new Long(Runtime.getRuntime().totalMemory()) / 1024L));
        result.add(new Metric<Long>("mem.free", new Long(Runtime.getRuntime().freeMemory()) / 1024L));
        result.add(new Metric<Integer>("processors", Runtime.getRuntime().availableProcessors()));
        return result;
    }
}

