/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.env", ignoreUnknownFields=false)
public class EnvironmentEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements EnvironmentAware {
    private Environment environment;
    private String[] keysToSanitize = new String[]{"password", "secret", "key"};

    public EnvironmentEndpoint() {
        super("env");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = keysToSanitize;
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("profiles", this.environment.getActiveProfiles());
        for (PropertySource<?> source : this.getPropertySources()) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String name : enumerable.getPropertyNames()) {
                map.put(name, this.sanitize(name, enumerable.getProperty(name)));
            }
            result.put(source.getName(), map);
        }
        return result;
    }

    private Iterable<PropertySource<?>> getPropertySources() {
        if (this.environment != null && this.environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)this.environment).getPropertySources();
        }
        return new StandardEnvironment().getPropertySources();
    }

    public Object sanitize(String name, Object object) {
        for (String keyToSanitize : this.keysToSanitize) {
            if (!name.toLowerCase().endsWith(keyToSanitize)) continue;
            return object == null ? null : "******";
        }
        return object;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

