/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@ConditionalOnBean(value={CounterService.class, GaugeService.class})
@ConditionalOnClass(value={Servlet.class, ServletRegistration.class, OncePerRequestFilter.class})
@AutoConfigureAfter(value={MetricRepositoryAutoConfiguration.class})
public class MetricFilterAutoConfiguration {
    private static final int UNDEFINED_HTTP_STATUS = 999;
    private static final String UNKNOWN_PATH_SUFFIX = "/unmapped";
    @Autowired
    private CounterService counterService;
    @Autowired
    private GaugeService gaugeService;

    @Bean
    public Filter metricFilter() {
        return new MetricsFilter();
    }

    @Order(value=-2147483648)
    private final class MetricsFilter
    extends OncePerRequestFilter {
        private MetricsFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            UrlPathHelper helper = new UrlPathHelper();
            String suffix = helper.getPathWithinApplication(request);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                stopWatch.stop();
                int status = this.getStatus(response);
                Object bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                HttpStatus httpStatus = HttpStatus.OK;
                try {
                    httpStatus = HttpStatus.valueOf((int)status);
                }
                catch (Exception ex) {}
                if (bestMatchingPattern != null) {
                    suffix = this.fixSpecialCharacters(bestMatchingPattern.toString());
                } else if (httpStatus.is4xxClientError()) {
                    suffix = MetricFilterAutoConfiguration.UNKNOWN_PATH_SUFFIX;
                }
                String gaugeKey = this.getKey("response" + suffix);
                MetricFilterAutoConfiguration.this.gaugeService.submit(gaugeKey, stopWatch.getTotalTimeMillis());
                String counterKey = this.getKey("status." + status + suffix);
                MetricFilterAutoConfiguration.this.counterService.increment(counterKey);
            }
        }

        private String fixSpecialCharacters(String value) {
            String result = value.replaceAll("[{}]", "-");
            result = result.replace("**", "-star-star-");
            result = result.replace("*", "-star-");
            result = result.replace("/-", "/");
            if ((result = result.replace("-/", "/")).endsWith("-")) {
                result = result.substring(0, result.length() - 1);
            }
            if (result.startsWith("-")) {
                result = result.substring(1);
            }
            return result;
        }

        private int getStatus(HttpServletResponse response) {
            try {
                return response.getStatus();
            }
            catch (Exception ex) {
                return 999;
            }
        }

        private String getKey(String string) {
            String value = string.replace("/", ".");
            if ((value = value.replace("..", ".")).endsWith(".")) {
                value = value + "root";
            }
            if (value.startsWith("_")) {
                value = value.substring(1);
            }
            return value;
        }
    }
}

