/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

@ConfigurationProperties(prefix="endpoints.env", ignoreUnknownFields=false)
public class EnvironmentEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements EnvironmentAware {
    private Environment environment;
    private final Sanitizer sanitizer = new Sanitizer();

    public EnvironmentEndpoint() {
        super("env");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        this.sanitizer.setKeysToSanitize(keysToSanitize);
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("profiles", this.environment.getActiveProfiles());
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String name : enumerable.getPropertyNames()) {
                map.put(name, this.sanitize(name, enumerable.getProperty(name)));
            }
            result.put(sourceName, map);
        }
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = this.environment != null && this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }

    public Object sanitize(String name, Object object) {
        return this.sanitizer.sanitize(name, object);
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

