/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class EndpointHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationContextAware {
    private final Set<MvcEndpoint> endpoints;
    private String prefix = "";
    private boolean disabled = false;
    private Set<HandlerMethod> principalHandlers = new HashSet<HandlerMethod>();

    public EndpointHandlerMapping(Collection<? extends MvcEndpoint> endpoints) {
        this.endpoints = new HashSet<MvcEndpoint>(endpoints);
        this.setOrder(-100);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.disabled) {
            for (MvcEndpoint endpoint : this.endpoints) {
                this.detectHandlerMethods(endpoint);
            }
        }
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        if (mapping == null) {
            return;
        }
        String[] patterns = this.getPatterns(handler, mapping);
        if (this.handlesPrincipal(method)) {
            this.principalHandlers.add(new HandlerMethod(handler, method));
        }
        super.registerHandlerMethod(handler, method, (Object)this.withNewPatterns(mapping, patterns));
    }

    private String[] getPatterns(Object handler, RequestMappingInfo mapping) {
        String path = this.getPath(handler);
        String prefix = StringUtils.hasText((String)this.prefix) ? this.prefix + path : path;
        Set defaultPatterns = mapping.getPatternsCondition().getPatterns();
        if (defaultPatterns.isEmpty()) {
            return new String[]{prefix};
        }
        ArrayList<String> patterns = new ArrayList<String>(defaultPatterns);
        for (int i = 0; i < patterns.size(); ++i) {
            patterns.set(i, prefix + (String)patterns.get(i));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private String getPath(Object handler) {
        if (handler instanceof String) {
            handler = this.getApplicationContext().getBean((String)handler);
        }
        if (handler instanceof MvcEndpoint) {
            return ((MvcEndpoint)handler).getPath();
        }
        return "";
    }

    private boolean handlesPrincipal(Method method) {
        for (Class<?> type : method.getParameterTypes()) {
            if (!Principal.class.equals(type)) continue;
            return true;
        }
        return false;
    }

    private RequestMappingInfo withNewPatterns(RequestMappingInfo mapping, String[] patternStrings) {
        PatternsRequestCondition patterns = new PatternsRequestCondition(patternStrings);
        return new RequestMappingInfo(patterns, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }

    public boolean isPrincipalHandler(HttpServletRequest request) {
        try {
            HandlerExecutionChain handlerChain = this.getHandler(request);
            Object handler = handlerChain == null ? null : handlerChain.getHandler();
            return handler != null && this.principalHandlers.contains(handler);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setPrefix(String prefix) {
        Assert.isTrue(("".equals(prefix) || StringUtils.startsWithIgnoreCase((String)prefix, (String)"/") ? 1 : 0) != 0, (String)"prefix must start with '/'");
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath(String endpoint) {
        return this.prefix + endpoint;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Set<? extends MvcEndpoint> getEndpoints() {
        return new HashSet<MvcEndpoint>(this.endpoints);
    }
}

