/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public class EnvironmentMvcEndpoint
extends EndpointMvcAdapter
implements EnvironmentAware {
    private Environment environment;

    public EnvironmentMvcEndpoint(EnvironmentEndpoint delegate) {
        super(delegate);
    }

    @RequestMapping(value={"/{name:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object value(@PathVariable String name) {
        String result = this.environment.getProperty(name);
        if (result == null) {
            throw new NoSuchPropertyException("No such property: " + name);
        }
        return ((EnvironmentEndpoint)this.getDelegate()).sanitize(name, result);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such property")
    public static class NoSuchPropertyException
    extends RuntimeException {
        public NoSuchPropertyException(String string) {
            super(string);
        }
    }
}

