/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.repository.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MetricRepository;
import org.springframework.boot.actuate.metrics.repository.redis.RedisUtils;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;

public class RedisMetricRepository
implements MetricRepository {
    private static final String DEFAULT_METRICS_PREFIX = "spring.metrics.";
    private static final String DEFAULT_KEY = "keys.spring.metrics";
    private String prefix = "spring.metrics.";
    private String key = "keys.spring.metrics";
    private BoundZSetOperations<String, String> zSetOperations;
    private final RedisOperations<String, String> redisOperations;

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory) {
        this(redisConnectionFactory, DEFAULT_METRICS_PREFIX);
    }

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory, String prefix) {
        this(redisConnectionFactory, prefix, DEFAULT_KEY);
    }

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory, String prefix, String key) {
        Assert.notNull((Object)redisConnectionFactory, (String)"RedisConnectionFactory must not be null");
        this.redisOperations = RedisUtils.stringTemplate(redisConnectionFactory);
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
        if (!DEFAULT_METRICS_PREFIX.equals(this.prefix) && DEFAULT_KEY.equals(key)) {
            key = "keys." + prefix;
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        this.key = key;
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.key);
    }

    @Override
    public Metric<?> findOne(String metricName) {
        String redisKey = this.keyFor(metricName);
        String raw = (String)this.redisOperations.opsForValue().get((Object)redisKey);
        return this.deserialize(redisKey, raw, this.zSetOperations.score((Object)redisKey));
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        Set keys = this.zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList result = new ArrayList(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            String key = (String)keysIt.next();
            Metric<?> value = this.deserialize(key, v, this.zSetOperations.score((Object)key));
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public long count() {
        return this.zSetOperations.size();
    }

    @Override
    public void increment(Delta<?> delta) {
        String name = delta.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        double value = this.zSetOperations.incrementScore((Object)key, ((Number)delta.getValue()).doubleValue());
        String raw = this.serialize(new Metric<Double>(name, value, delta.getTimestamp()));
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    @Override
    public void set(Metric<?> value) {
        String name = value.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        this.zSetOperations.add((Object)key, ((Number)value.getValue()).doubleValue());
        String raw = this.serialize(value);
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    @Override
    public void reset(String metricName) {
        String key = this.keyFor(metricName);
        if (this.zSetOperations.remove(new Object[]{key}) == 1L) {
            this.redisOperations.delete((Object)key);
        }
    }

    private Metric<?> deserialize(String redisKey, String v, Double value) {
        if (redisKey == null || v == null || !redisKey.startsWith(this.prefix)) {
            return null;
        }
        Date timestamp = new Date(Long.valueOf(v));
        return new Metric<Double>(this.nameFor(redisKey), value, timestamp);
    }

    private String serialize(Metric<?> entity) {
        return String.valueOf(entity.getTimestamp().getTime());
    }

    private String keyFor(String name) {
        return this.prefix + name;
    }

    private String nameFor(String redisKey) {
        return redisKey.substring(this.prefix.length());
    }

    private void trackMembership(String redisKey) {
        this.zSetOperations.incrementScore((Object)redisKey, 0.0);
    }
}

