/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.management.MBeanServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportProperties;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanExporter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnExpression(value="${endpoints.jmx.enabled:true} && ${spring.jmx.enabled:true}")
@AutoConfigureAfter(value={EndpointAutoConfiguration.class, JmxAutoConfiguration.class})
@EnableConfigurationProperties(value={EndpointMBeanExportProperties.class})
public class EndpointMBeanExportAutoConfiguration {
    @Autowired
    EndpointMBeanExportProperties properties = new EndpointMBeanExportProperties();

    @Bean
    public EndpointMBeanExporter endpointMBeanExporter(MBeanServer server) {
        EndpointMBeanExporter mbeanExporter = new EndpointMBeanExporter();
        String domain = this.properties.getDomain();
        if (StringUtils.hasText((String)domain)) {
            mbeanExporter.setDomain(domain);
        }
        mbeanExporter.setServer(server);
        mbeanExporter.setEnsureUniqueRuntimeObjectNames(this.properties.isUniqueNames());
        mbeanExporter.setObjectNameStaticProperties(this.properties.getStaticNames());
        return mbeanExporter;
    }

    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServer mbeanServer() {
        return new JmxAutoConfiguration().mbeanServer();
    }

    static class JmxCondition
    extends SpringBootCondition {
        JmxCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String endpointEnabled = context.getEnvironment().getProperty("endpoints.jmx.enabled", "true");
            String jmxEnabled = context.getEnvironment().getProperty("spring.jmx.enabled", "true");
            return new ConditionOutcome("true".equalsIgnoreCase(endpointEnabled) && "true".equalsIgnoreCase(jmxEnabled), "JMX endpoint and JMX enabled");
        }
    }
}

