/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Order(value=-2147483648)
final class MetricsFilter
extends OncePerRequestFilter {
    private static final String ATTRIBUTE_STOP_WATCH = MetricsFilter.class.getName() + ".StopWatch";
    private static final int UNDEFINED_HTTP_STATUS = 999;
    private static final String UNKNOWN_PATH_SUFFIX = "/unmapped";
    private static final Log logger = LogFactory.getLog(MetricsFilter.class);
    private final CounterService counterService;
    private final GaugeService gaugeService;

    public MetricsFilter(CounterService counterService, GaugeService gaugeService) {
        this.counterService = counterService;
        this.gaugeService = gaugeService;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        StopWatch stopWatch = this.createStopWatchIfNecessary(request);
        String path = new UrlPathHelper().getPathWithinApplication(request);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            status = this.getStatus(response);
        }
        finally {
            if (!request.isAsyncStarted()) {
                stopWatch.stop();
                request.removeAttribute(ATTRIBUTE_STOP_WATCH);
                this.recordMetrics(request, path, status, stopWatch.getTotalTimeMillis());
            }
        }
    }

    private StopWatch createStopWatchIfNecessary(HttpServletRequest request) {
        StopWatch stopWatch = (StopWatch)request.getAttribute(ATTRIBUTE_STOP_WATCH);
        if (stopWatch == null) {
            stopWatch = new StopWatch();
            stopWatch.start();
            request.setAttribute(ATTRIBUTE_STOP_WATCH, (Object)stopWatch);
        }
        return stopWatch;
    }

    private int getStatus(HttpServletResponse response) {
        try {
            return response.getStatus();
        }
        catch (Exception ex) {
            return 999;
        }
    }

    private void recordMetrics(HttpServletRequest request, String path, int status, long time) {
        String suffix = this.getFinalStatus(request, path, status);
        this.submitToGauge(this.getKey("response" + suffix), time);
        this.incrementCounter(this.getKey("status." + status + suffix));
    }

    private String getFinalStatus(HttpServletRequest request, String path, int status) {
        Object bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (bestMatchingPattern != null) {
            return this.fixSpecialCharacters(bestMatchingPattern.toString());
        }
        HttpStatus.Series series = this.getSeries(status);
        if (HttpStatus.Series.CLIENT_ERROR.equals((Object)series) || HttpStatus.Series.REDIRECTION.equals((Object)series)) {
            return UNKNOWN_PATH_SUFFIX;
        }
        return path;
    }

    private String fixSpecialCharacters(String value) {
        String result = value.replaceAll("[{}]", "-");
        result = result.replace("**", "-star-star-");
        result = result.replace("*", "-star-");
        result = result.replace("/-", "/");
        if ((result = result.replace("-/", "/")).endsWith("-")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith("-")) {
            result = result.substring(1);
        }
        return result;
    }

    private HttpStatus.Series getSeries(int status) {
        try {
            return HttpStatus.valueOf((int)status).series();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getKey(String string) {
        String value = string.replace("/", ".");
        if ((value = value.replace("..", ".")).endsWith(".")) {
            value = value + "root";
        }
        if (value.startsWith("_")) {
            value = value.substring(1);
        }
        return value;
    }

    private void submitToGauge(String metricName, double value) {
        try {
            this.gaugeService.submit(metricName, value);
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to submit gauge metric '" + metricName + "'"), (Throwable)ex);
        }
    }

    private void incrementCounter(String metricName) {
        try {
            this.counterService.increment(metricName);
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to submit counter metric '" + metricName + "'"), (Throwable)ex);
        }
    }
}

