/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.Status;

public abstract class AbstractHealthAggregator
implements HealthAggregator {
    @Override
    public final Health aggregate(Map<String, Health> healths) {
        ArrayList<Status> statusCandidates = new ArrayList<Status>();
        LinkedHashMap<String, Health> details = new LinkedHashMap<String, Health>();
        for (Map.Entry<String, Health> entry : healths.entrySet()) {
            details.put(entry.getKey(), entry.getValue());
            statusCandidates.add(entry.getValue().getStatus());
        }
        return new Health.Builder(this.aggregateStatus(statusCandidates), details).build();
    }

    protected abstract Status aggregateStatus(List<Status> var1);
}

