/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.liquibase", ignoreUnknownFields=true)
public class LiquibaseEndpoint
extends AbstractEndpoint<List<Map<String, ?>>> {
    private final SpringLiquibase liquibase;

    public LiquibaseEndpoint(SpringLiquibase liquibase) {
        super("liquibase");
        Assert.notNull((Object)liquibase, (String)"Liquibase must not be null");
        this.liquibase = liquibase;
    }

    @Override
    public List<Map<String, ?>> invoke() {
        StandardChangeLogHistoryService service = new StandardChangeLogHistoryService();
        try {
            DatabaseFactory factory = DatabaseFactory.getInstance();
            DataSource dataSource = this.liquibase.getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = factory.findCorrectDatabaseImplementation((DatabaseConnection)connection);
            return service.queryDatabaseChangeLogTable(database);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to get Liquibase changelog", ex);
        }
    }
}

