/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="endpoints.configprops")
public class ConfigurationPropertiesReportEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private static final String CGLIB_FILTER_ID = "cglibFilter";
    private final Sanitizer sanitizer = new Sanitizer();
    private ApplicationContext context;

    public ConfigurationPropertiesReportEndpoint() {
        super("configprops");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        this.sanitizer.setKeysToSanitize(keysToSanitize);
    }

    @Override
    public Map<String, Object> invoke() {
        return this.extract(this.context);
    }

    protected Map<String, Object> extract(ApplicationContext context) {
        ObjectMapper mapper = new ObjectMapper();
        this.configureObjectMapper(mapper);
        return this.extract(context, mapper);
    }

    private Map<String, Object> extract(ApplicationContext context, ObjectMapper mapper) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigurationBeanFactoryMetaData beanFactoryMetaData = this.getBeanFactoryMetaData(context);
        Map<String, Object> beans = this.getConfigurationPropertiesBeans(context, beanFactoryMetaData);
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            String beanName = entry.getKey();
            Object bean = entry.getValue();
            HashMap<String, Object> root = new HashMap<String, Object>();
            String prefix = this.extractPrefix(context, beanFactoryMetaData, beanName, bean);
            root.put("prefix", prefix);
            root.put("properties", this.sanitize(prefix, this.safeSerialize(mapper, bean, prefix)));
            result.put(beanName, root);
        }
        if (context.getParent() != null) {
            result.put("parent", this.extract(context.getParent(), mapper));
        }
        return result;
    }

    private ConfigurationBeanFactoryMetaData getBeanFactoryMetaData(ApplicationContext context) {
        Map beans = context.getBeansOfType(ConfigurationBeanFactoryMetaData.class);
        if (beans.size() == 1) {
            return (ConfigurationBeanFactoryMetaData)beans.values().iterator().next();
        }
        return null;
    }

    private Map<String, Object> getConfigurationPropertiesBeans(ApplicationContext context, ConfigurationBeanFactoryMetaData beanFactoryMetaData) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.putAll(context.getBeansWithAnnotation(ConfigurationProperties.class));
        if (beanFactoryMetaData != null) {
            beans.putAll(beanFactoryMetaData.getBeansWithFactoryAnnotation(ConfigurationProperties.class));
        }
        return beans;
    }

    private Map<String, Object> safeSerialize(ObjectMapper mapper, Object bean, String prefix) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>((Map)mapper.convertValue(bean, Map.class));
            return result;
        }
        catch (Exception ex) {
            return new HashMap<String, Object>(Collections.singletonMap("error", "Cannot serialize '" + prefix + "'"));
        }
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.applyCglibFilters(mapper);
        this.applySerializationModifier(mapper);
    }

    private void applySerializationModifier(ObjectMapper mapper) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new GenericSerializerModifier());
        mapper.setSerializerFactory(factory);
    }

    private void applyCglibFilters(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new CglibAnnotationIntrospector());
        mapper.setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter(CGLIB_FILTER_ID, (SimpleBeanPropertyFilter)new CglibBeanPropertyFilter()));
    }

    private String extractPrefix(ApplicationContext context, ConfigurationBeanFactoryMetaData beanFactoryMetaData, String beanName, Object bean) {
        ConfigurationProperties override;
        ConfigurationProperties annotation = (ConfigurationProperties)context.findAnnotationOnBean(beanName, ConfigurationProperties.class);
        if (beanFactoryMetaData != null && (override = (ConfigurationProperties)beanFactoryMetaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            annotation = override;
        }
        return StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.prefix();
    }

    private Map<String, Object> sanitize(String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            String qualifiedKey = (prefix.length() == 0 ? prefix : prefix + ".") + key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                map.put(key, this.sanitize(qualifiedKey, (Map)value));
                continue;
            }
            value = this.sanitizer.sanitize(key, value);
            value = this.sanitizer.sanitize(qualifiedKey, value);
            map.put(key, value);
        }
        return map;
    }

    protected static class GenericSerializerModifier
    extends BeanSerializerModifier {
        protected GenericSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : beanProperties) {
                boolean readable = this.isReadable(beanDesc, writer);
                if (!readable) continue;
                result.add(writer);
            }
            return result;
        }

        private boolean isReadable(BeanDescription beanDesc, BeanPropertyWriter writer) {
            String parentType = beanDesc.getType().getRawClass().getName();
            String type = writer.getPropertyType().getName();
            AnnotatedMethod setter = this.findSetter(beanDesc, writer);
            return setter != null || ClassUtils.getPackageName((String)parentType).equals(ClassUtils.getPackageName((String)type));
        }

        private AnnotatedMethod findSetter(BeanDescription beanDesc, BeanPropertyWriter writer) {
            Class type;
            String name = "set" + StringUtils.capitalize((String)writer.getName());
            AnnotatedMethod setter = beanDesc.findMethod(name, new Class[]{type = writer.getPropertyType()});
            if (setter == null && type.equals(Boolean.TYPE)) {
                setter = beanDesc.findMethod(name, new Class[]{Boolean.class});
            }
            return setter;
        }
    }

    private static class CglibBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private CglibBeanPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }
    }

    private static class CglibAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private CglibAnnotationIntrospector() {
        }

        public Object findFilterId(Annotated a) {
            Object id = super.findFilterId(a);
            if (id == null) {
                id = ConfigurationPropertiesReportEndpoint.CGLIB_FILTER_ID;
            }
            return id;
        }
    }
}

