/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class DefaultCounterService
implements CounterService {
    private final MetricWriter writer;
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();

    public DefaultCounterService(MetricWriter writer) {
        this.writer = writer;
    }

    @Override
    public void increment(String metricName) {
        this.writer.increment(new Delta<Long>(this.wrap(metricName), 1L));
    }

    @Override
    public void decrement(String metricName) {
        this.writer.increment(new Delta<Long>(this.wrap(metricName), -1L));
    }

    @Override
    public void reset(String metricName) {
        this.writer.reset(this.wrap(metricName));
    }

    private String wrap(String metricName) {
        if (this.names.containsKey(metricName)) {
            return this.names.get(metricName);
        }
        if (metricName.startsWith("counter.") || metricName.startsWith("meter.")) {
            return metricName;
        }
        String name = "counter." + metricName;
        this.names.put(metricName, name);
        return name;
    }
}

