/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public abstract class AbstractJmxCacheStatisticsProvider<C extends Cache>
implements CacheStatisticsProvider<C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJmxCacheStatisticsProvider.class);
    private MBeanServer mBeanServer;
    private Map<String, ObjectNameWrapper> caches = new ConcurrentHashMap<String, ObjectNameWrapper>();

    @Override
    public CacheStatistics getCacheStatistics(CacheManager cacheManager, C cache) {
        try {
            ObjectName objectName = this.internalGetObjectName(cache);
            return objectName == null ? null : this.getCacheStatistics(objectName);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected abstract ObjectName getObjectName(C var1) throws MalformedObjectNameException;

    protected abstract CacheStatistics getCacheStatistics(ObjectName var1);

    private ObjectName internalGetObjectName(C cache) throws MalformedObjectNameException {
        String cacheName = cache.getName();
        ObjectNameWrapper value = this.caches.get(cacheName);
        if (value != null) {
            return value.objectName;
        }
        ObjectName objectName = this.getObjectName(cache);
        this.caches.put(cacheName, new ObjectNameWrapper(objectName));
        return objectName;
    }

    protected MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mBeanServer;
    }

    protected <T> T getAttribute(ObjectName objectName, String attributeName, Class<T> type) {
        try {
            Object attribute = this.getMBeanServer().getAttribute(objectName, attributeName);
            return type.cast(attribute);
        }
        catch (MBeanException ex) {
            throw new IllegalStateException(ex);
        }
        catch (AttributeNotFoundException ex) {
            throw new IllegalStateException("Unexpected: MBean with name '" + objectName + "' " + "does not expose attribute with name " + attributeName, ex);
        }
        catch (ReflectionException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstanceNotFoundException ex) {
            logger.warn("Cache statistics are no longer available", (Throwable)ex);
            return null;
        }
    }

    private static class ObjectNameWrapper {
        private final ObjectName objectName;

        ObjectNameWrapper(ObjectName objectName) {
            this.objectName = objectName;
        }
    }
}

