/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@ConfigurationProperties(prefix="endpoints.logfile")
public class LogFileMvcEndpoint
implements MvcEndpoint,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(LogFileMvcEndpoint.class);
    @NotNull
    @Pattern(regexp="/.*", message="Path must start with /")
    private String path = "/logfile";
    private boolean enabled = true;
    private Boolean sensitive;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, true);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD})
    public void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isEnabled()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        Resource resource = this.getLogFileResource();
        new Handler(resource).handleRequest(request, response);
    }

    private Resource getLogFileResource() {
        LogFile logFile = LogFile.get((PropertyResolver)this.environment);
        if (logFile == null) {
            logger.debug((Object)"Missing 'logging.file' or 'logging.path' properties");
            return null;
        }
        FileSystemResource resource = new FileSystemResource(logFile.toString());
        if (!resource.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Log file '" + resource + "' does not exist"));
            }
            return null;
        }
        return resource;
    }

    private static class Handler
    extends ResourceHttpRequestHandler {
        private final Resource resource;

        Handler(Resource resource) {
            this.resource = resource;
        }

        protected Resource getResource(HttpServletRequest request) throws IOException {
            return this.resource;
        }

        protected MediaType getMediaType(Resource resource) {
            return MediaType.TEXT_PLAIN;
        }
    }
}

