/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.util.StringUtils;

public abstract class AbstractMetricExporter
implements Exporter,
Closeable,
Flushable {
    private static final Log logger = LogFactory.getLog(AbstractMetricExporter.class);
    private final String prefix;
    private Date earliestTimestamp = new Date();
    private boolean ignoreTimestamps = false;
    private boolean sendLatest = true;
    private volatile AtomicBoolean processing = new AtomicBoolean(false);
    private Date latestTimestamp = new Date(0L);

    public AbstractMetricExporter(String prefix) {
        this.prefix = !StringUtils.hasText((String)prefix) ? "" : (prefix.endsWith(".") ? prefix : prefix + ".");
    }

    public void setEarliestTimestamp(Date earliestTimestamp) {
        this.earliestTimestamp = earliestTimestamp;
    }

    public void setIgnoreTimestamps(boolean ignoreTimestamps) {
        this.ignoreTimestamps = ignoreTimestamps;
    }

    public void setSendLatest(boolean sendLatest) {
        this.sendLatest = sendLatest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() {
        if (this.processing.compareAndSet(false, true)) {
            long latestTimestamp = System.currentTimeMillis();
            try {
                this.exportGroups();
            }
            catch (Exception ex) {
                logger.warn((Object)("Could not write to MetricWriter: " + ex.getClass() + ": " + ex.getMessage()));
            }
            finally {
                this.latestTimestamp = new Date(latestTimestamp);
                this.flushQuietly();
                this.processing.set(false);
            }
        }
    }

    private void exportGroups() {
        for (String group : this.groups()) {
            ArrayList values = new ArrayList();
            for (Metric<?> metric : this.next(group)) {
                Date timestamp = metric.getTimestamp();
                if (!this.canExportTimestamp(timestamp)) continue;
                values.add(this.getPrefixedMetric(metric));
            }
            if (values.isEmpty()) continue;
            this.write(group, values);
        }
    }

    private Metric<?> getPrefixedMetric(Metric<?> metric) {
        String name = this.prefix + metric.getName();
        return new Metric(name, metric.getValue(), metric.getTimestamp());
    }

    private boolean canExportTimestamp(Date timestamp) {
        if (this.ignoreTimestamps) {
            return true;
        }
        if (this.earliestTimestamp.after(timestamp)) {
            return false;
        }
        return !this.sendLatest || !this.latestTimestamp.after(timestamp);
    }

    private void flushQuietly() {
        try {
            this.flush();
        }
        catch (Exception ex) {
            logger.warn((Object)("Could not flush MetricWriter: " + ex.getClass() + ": " + ex.getMessage()));
        }
    }

    @Override
    public void close() throws IOException {
        this.export();
        this.flushQuietly();
    }

    @Override
    public void flush() {
    }

    protected Iterable<String> groups() {
        return Collections.singleton("");
    }

    protected abstract void write(String var1, Collection<Metric<?>> var2);

    protected abstract Iterable<Metric<?>> next(String var1);
}

