/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.actuate.endpoint.mvc.NamePatternFilter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.env")
public class EnvironmentMvcEndpoint
extends EndpointMvcAdapter
implements EnvironmentAware {
    private Environment environment;

    public EnvironmentMvcEndpoint(EnvironmentEndpoint delegate) {
        super(delegate);
    }

    @GetMapping(value={"/{name:.*}"}, produces={"application/json"})
    @ResponseBody
    @HypermediaDisabled
    public Object value(@PathVariable String name) {
        if (!this.getDelegate().isEnabled()) {
            return this.getDisabledResponse();
        }
        return new NamePatternEnvironmentFilter(this.environment).getResults(name);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such property")
    public static class NoSuchPropertyException
    extends RuntimeException {
        public NoSuchPropertyException(String string) {
            super(string);
        }
    }

    private class NamePatternEnvironmentFilter
    extends NamePatternFilter<Environment> {
        NamePatternEnvironmentFilter(Environment source) {
            super(source);
        }

        @Override
        protected void getNames(Environment source, NamePatternFilter.NameCallback callback) {
            if (source instanceof ConfigurableEnvironment) {
                this.getNames((PropertySources)((ConfigurableEnvironment)source).getPropertySources(), callback);
            }
        }

        @Override
        private void getNames(PropertySources propertySources, NamePatternFilter.NameCallback callback) {
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource source = (EnumerablePropertySource)propertySource;
                for (String name : source.getPropertyNames()) {
                    callback.addName(name);
                }
            }
        }

        @Override
        protected Object getOptionalValue(Environment source, String name) {
            Object result;
            Environment resolver = source;
            if (source instanceof ConfigurableEnvironment) {
                resolver = new PropertySourcesPropertyResolver((PropertySources)((ConfigurableEnvironment)source).getPropertySources());
                ((PropertySourcesPropertyResolver)resolver).setIgnoreUnresolvableNestedPlaceholders(true);
            }
            if ((result = resolver.getProperty(name)) != null) {
                result = ((EnvironmentEndpoint)EnvironmentMvcEndpoint.this.getDelegate()).sanitize(name, result);
            }
            return result;
        }

        @Override
        protected Object getValue(Environment source, String name) {
            String result = source.getProperty(name);
            if (result == null) {
                throw new NoSuchPropertyException("No such property: " + name);
            }
            return ((EnvironmentEndpoint)EnvironmentMvcEndpoint.this.getDelegate()).sanitize(name, result);
        }
    }
}

