/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.trace.TraceProperties;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.actuate.trace.WebRequestTraceFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, ServletRegistration.class})
@AutoConfigureAfter(value={TraceRepositoryAutoConfiguration.class})
@ConditionalOnProperty(prefix="endpoints.trace.filter", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceProperties.class})
public class TraceWebFilterAutoConfiguration {
    private final TraceRepository traceRepository;
    private final TraceProperties traceProperties;
    private final ErrorAttributes errorAttributes;

    public TraceWebFilterAutoConfiguration(TraceRepository traceRepository, TraceProperties traceProperties, ObjectProvider<ErrorAttributes> errorAttributes) {
        this.traceRepository = traceRepository;
        this.traceProperties = traceProperties;
        this.errorAttributes = (ErrorAttributes)errorAttributes.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebRequestTraceFilter webRequestLoggingFilter(BeanFactory beanFactory) {
        WebRequestTraceFilter filter = new WebRequestTraceFilter(this.traceRepository, this.traceProperties);
        if (this.errorAttributes != null) {
            filter.setErrorAttributes(this.errorAttributes);
        }
        return filter;
    }
}

