/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;

public class MetricsEndpointMetricReader
implements MetricReader {
    private final MetricsEndpoint endpoint;

    public MetricsEndpointMetricReader(MetricsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Metric<?> findOne(String metricName) {
        Metric<Number> metric = null;
        Object value = this.endpoint.invoke().get(metricName);
        if (value != null) {
            metric = new Metric<Number>(metricName, (Number)value);
        }
        return metric;
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        ArrayList metrics = new ArrayList();
        Object values = this.endpoint.invoke();
        Date timestamp = new Date();
        for (Map.Entry entry : values.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            metrics.add(new Metric<Number>(name, (Number)value, timestamp));
        }
        return metrics;
    }

    @Override
    public long count() {
        return this.endpoint.invoke().size();
    }
}

