/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.lang.reflect.Modifier;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.actuate.autoconfigure.EndpointWebMvcChildContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfigurationsImportSelector;
import org.springframework.boot.actuate.autoconfigure.ManagementContextResolver;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementServerPropertiesAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.data.rest.RepositoryRestMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.hateoas.HypermediaAutoConfiguration;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.ServerPropertiesAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.web.filter.ApplicationContextHeaderFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={PropertyPlaceholderAutoConfiguration.class, EmbeddedServletContainerAutoConfiguration.class, WebMvcAutoConfiguration.class, ManagementServerPropertiesAutoConfiguration.class, RepositoryRestMvcAutoConfiguration.class, HypermediaAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class})
public class EndpointWebMvcAutoConfiguration
implements ApplicationContextAware,
BeanFactoryAware,
SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(EndpointWebMvcAutoConfiguration.class);
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    public ManagementContextResolver managementContextResolver() {
        return new ManagementContextResolver(this.applicationContext);
    }

    @Bean
    public ManagementServletContext managementServletContext(final ManagementServerProperties properties) {
        return new ManagementServletContext(){

            @Override
            public String getContextPath() {
                return properties.getContextPath();
            }
        };
    }

    public void afterSingletonsInstantiated() {
        ManagementServerPort managementPort = ManagementServerPort.DIFFERENT;
        if (this.applicationContext instanceof WebApplicationContext) {
            managementPort = ManagementServerPort.get(this.applicationContext.getEnvironment(), this.beanFactory);
        }
        if (managementPort == ManagementServerPort.DIFFERENT) {
            if (this.applicationContext instanceof EmbeddedWebApplicationContext && ((EmbeddedWebApplicationContext)this.applicationContext).getEmbeddedServletContainer() != null) {
                this.createChildManagementContext();
            } else {
                logger.warn((Object)"Could not start embedded management container on different port (management endpoints are still available through JMX)");
            }
        }
        if (managementPort == ManagementServerPort.SAME) {
            if (((Boolean)new RelaxedPropertyResolver((PropertyResolver)this.applicationContext.getEnvironment(), "management.ssl.").getProperty("enabled", Boolean.class, (Object)false)).booleanValue()) {
                throw new IllegalStateException("Management-specific SSL cannot be configured as the management server is not listening on a separate port");
            }
            if (this.applicationContext.getEnvironment() instanceof ConfigurableEnvironment) {
                this.addLocalManagementPortPropertyAlias((ConfigurableEnvironment)this.applicationContext.getEnvironment());
            }
        }
    }

    private void createChildManagementContext() {
        AnnotationConfigEmbeddedWebApplicationContext childContext = new AnnotationConfigEmbeddedWebApplicationContext();
        childContext.setParent(this.applicationContext);
        childContext.setNamespace("management");
        childContext.setId(this.applicationContext.getId() + ":management");
        childContext.setClassLoader(this.applicationContext.getClassLoader());
        childContext.register(new Class[]{EndpointWebMvcChildContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class, EmbeddedServletContainerAutoConfiguration.class, DispatcherServletAutoConfiguration.class});
        this.registerEmbeddedServletContainerFactory(childContext);
        CloseManagementContextListener.addIfPossible(this.applicationContext, (ConfigurableApplicationContext)childContext);
        childContext.refresh();
        this.managementContextResolver().setApplicationContext((ApplicationContext)childContext);
    }

    private void registerEmbeddedServletContainerFactory(AnnotationConfigEmbeddedWebApplicationContext childContext) {
        try {
            ConfigurableListableBeanFactory beanFactory = childContext.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition("embeddedServletContainerFactory", (BeanDefinition)new RootBeanDefinition(this.determineEmbeddedServletContainerFactoryClass()));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Class<?> determineEmbeddedServletContainerFactoryClass() throws NoSuchBeanDefinitionException {
        Class<?> servletContainerFactoryClass = ((EmbeddedServletContainerFactory)this.applicationContext.getBean(EmbeddedServletContainerFactory.class)).getClass();
        if (this.cannotBeInstantiated(servletContainerFactoryClass)) {
            throw new FatalBeanException("EmbeddedServletContainerFactory implementation " + servletContainerFactoryClass.getName() + " cannot be instantiated. To allow a separate management port to be used, a top-level class or static inner class should be used instead");
        }
        return servletContainerFactoryClass;
    }

    private boolean cannotBeInstantiated(Class<?> clazz) {
        return clazz.isLocalClass() || clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) || clazz.isAnonymousClass();
    }

    private void addLocalManagementPortPropertyAlias(final ConfigurableEnvironment environment) {
        environment.getPropertySources().addLast((PropertySource)new PropertySource<Object>("Management Server"){

            public Object getProperty(String name) {
                if ("local.management.port".equals(name)) {
                    return environment.getProperty("local.server.port");
                }
                return null;
            }
        });
    }

    protected static enum ManagementServerPort {
        DISABLE,
        SAME,
        DIFFERENT;


        public static ManagementServerPort get(Environment environment, BeanFactory beanFactory) {
            Integer managementPort;
            Integer serverPort = ManagementServerPort.getPortProperty(environment, "server.");
            if (serverPort == null && ManagementServerPort.hasCustomBeanDefinition(beanFactory, ServerProperties.class, ServerPropertiesAutoConfiguration.class)) {
                serverPort = ManagementServerPort.getTemporaryBean(beanFactory, ServerProperties.class).getPort();
            }
            if ((managementPort = ManagementServerPort.getPortProperty(environment, "management.")) == null && ManagementServerPort.hasCustomBeanDefinition(beanFactory, ManagementServerProperties.class, ManagementServerPropertiesAutoConfiguration.class)) {
                managementPort = ManagementServerPort.getTemporaryBean(beanFactory, ManagementServerProperties.class).getPort();
            }
            if (managementPort != null && managementPort < 0) {
                return DISABLE;
            }
            return managementPort == null || serverPort == null && managementPort.equals(8080) || managementPort != 0 && managementPort.equals(serverPort) ? SAME : DIFFERENT;
        }

        private static <T> T getTemporaryBean(BeanFactory beanFactory, Class<T> type) {
            if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
                return null;
            }
            ConfigurableListableBeanFactory listable = (ConfigurableListableBeanFactory)beanFactory;
            String[] names = listable.getBeanNamesForType(type, true, false);
            if (names == null || names.length != 1) {
                return null;
            }
            return ManagementServerPort.createTemporaryBean(type, listable, listable.getBeanDefinition(names[0]));
        }

        private static <T> T createTemporaryBean(Class<T> type, ConfigurableListableBeanFactory parent, BeanDefinition definition) {
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory((BeanFactory)parent);
            beanFactory.registerBeanDefinition(type.getName(), definition);
            return (T)beanFactory.getBean(type);
        }

        private static Integer getPortProperty(Environment environment, String prefix) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, prefix);
            return (Integer)resolver.getProperty("port", Integer.class);
        }

        private static <T> boolean hasCustomBeanDefinition(BeanFactory beanFactory, Class<T> type, Class<?> configClass) {
            if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
                return false;
            }
            return ManagementServerPort.hasCustomBeanDefinition((ConfigurableListableBeanFactory)beanFactory, type, configClass);
        }

        private static <T> boolean hasCustomBeanDefinition(ConfigurableListableBeanFactory beanFactory, Class<T> type, Class<?> configClass) {
            MethodMetadata factoryMethodMetadata;
            String[] names = beanFactory.getBeanNamesForType(type, true, false);
            if (names == null || names.length != 1) {
                return false;
            }
            BeanDefinition definition = beanFactory.getBeanDefinition(names[0]);
            if (definition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)definition).getFactoryMethodMetadata()) != null) {
                String className = factoryMethodMetadata.getDeclaringClassName();
                return !configClass.getName().equals(className);
            }
            return true;
        }
    }

    private static class OnManagementMvcCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        private OnManagementMvcCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Management Server MVC", (Object[])new Object[0]);
            if (!(context.getResourceLoader() instanceof WebApplicationContext)) {
                return ConditionOutcome.noMatch((ConditionMessage)message.because("non WebApplicationContext"));
            }
            ManagementServerPort port = ManagementServerPort.get(context.getEnvironment(), (BeanFactory)context.getBeanFactory());
            if (port == ManagementServerPort.SAME) {
                return ConditionOutcome.match((ConditionMessage)message.because("port is same"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("port is not same"));
        }
    }

    private static class CloseManagementContextListener
    implements ApplicationListener<ApplicationEvent> {
        private final ApplicationContext parentContext;
        private final ConfigurableApplicationContext childContext;

        CloseManagementContextListener(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            this.parentContext = parentContext;
            this.childContext = childContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextClosedEvent) {
                this.onContextClosedEvent((ContextClosedEvent)event);
            }
            if (event instanceof ApplicationFailedEvent) {
                this.onApplicationFailedEvent((ApplicationFailedEvent)event);
            }
        }

        private void onContextClosedEvent(ContextClosedEvent event) {
            this.propagateCloseIfNecessary(event.getApplicationContext());
        }

        private void onApplicationFailedEvent(ApplicationFailedEvent event) {
            this.propagateCloseIfNecessary((ApplicationContext)event.getApplicationContext());
        }

        private void propagateCloseIfNecessary(ApplicationContext applicationContext) {
            if (applicationContext == this.parentContext) {
                this.childContext.close();
            }
        }

        public static void addIfPossible(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            if (parentContext instanceof ConfigurableApplicationContext) {
                CloseManagementContextListener.add((ConfigurableApplicationContext)parentContext, childContext);
            }
        }

        private static void add(ConfigurableApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            parentContext.addApplicationListener((ApplicationListener)new CloseManagementContextListener((ApplicationContext)parentContext, childContext));
        }
    }

    @Configuration
    @Conditional(value={OnManagementMvcCondition.class})
    @Import(value={ManagementContextConfigurationsImportSelector.class})
    protected static class EndpointWebMvcConfiguration {
        protected EndpointWebMvcConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="management", name={"add-application-context-header"}, matchIfMissing=true, havingValue="true")
    protected static class ApplicationContextFilterConfiguration {
        protected ApplicationContextFilterConfiguration() {
        }

        @Bean
        public ApplicationContextHeaderFilter applicationContextIdFilter(ApplicationContext context) {
            return new ApplicationContextHeaderFilter(context);
        }
    }
}

