/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.autoconfigure.EndpointCorsProperties;
import org.springframework.boot.actuate.autoconfigure.HealthMvcEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.AuditEventsMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMappingCustomizer;
import org.springframework.boot.actuate.endpoint.mvc.EnvironmentMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HealthMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HeapdumpMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.LogFileMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.LoggersMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MetricsMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpointSecurityInterceptor;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.actuate.endpoint.mvc.ShutdownMvcEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerInterceptor;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={HealthMvcEndpointProperties.class, EndpointCorsProperties.class})
public class EndpointWebMvcManagementContextConfiguration {
    private final HealthMvcEndpointProperties healthMvcEndpointProperties;
    private final ManagementServerProperties managementServerProperties;
    private final EndpointCorsProperties corsProperties;
    private final List<EndpointHandlerMappingCustomizer> mappingCustomizers;

    public EndpointWebMvcManagementContextConfiguration(HealthMvcEndpointProperties healthMvcEndpointProperties, ManagementServerProperties managementServerProperties, EndpointCorsProperties corsProperties, ObjectProvider<List<EndpointHandlerMappingCustomizer>> mappingCustomizers) {
        this.healthMvcEndpointProperties = healthMvcEndpointProperties;
        this.managementServerProperties = managementServerProperties;
        this.corsProperties = corsProperties;
        List providedCustomizers = (List)mappingCustomizers.getIfAvailable();
        this.mappingCustomizers = providedCustomizers == null ? Collections.emptyList() : providedCustomizers;
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointHandlerMapping endpointHandlerMapping() {
        Set<MvcEndpoint> endpoints = this.mvcEndpoints().getEndpoints();
        CorsConfiguration corsConfiguration = this.getCorsConfiguration(this.corsProperties);
        EndpointHandlerMapping mapping = new EndpointHandlerMapping((Collection<? extends MvcEndpoint>)endpoints, corsConfiguration);
        mapping.setPrefix(this.managementServerProperties.getContextPath());
        MvcEndpointSecurityInterceptor securityInterceptor = new MvcEndpointSecurityInterceptor(this.managementServerProperties.getSecurity().isEnabled(), this.managementServerProperties.getSecurity().getRoles());
        mapping.setSecurityInterceptor((HandlerInterceptor)securityInterceptor);
        for (EndpointHandlerMappingCustomizer customizer : this.mappingCustomizers) {
            customizer.customize(mapping);
        }
        return mapping;
    }

    private CorsConfiguration getCorsConfiguration(EndpointCorsProperties properties) {
        if (CollectionUtils.isEmpty(properties.getAllowedOrigins())) {
            return null;
        }
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(properties.getAllowedOrigins());
        if (!CollectionUtils.isEmpty(properties.getAllowedHeaders())) {
            configuration.setAllowedHeaders(properties.getAllowedHeaders());
        }
        if (!CollectionUtils.isEmpty(properties.getAllowedMethods())) {
            configuration.setAllowedMethods(properties.getAllowedMethods());
        }
        if (!CollectionUtils.isEmpty(properties.getExposedHeaders())) {
            configuration.setExposedHeaders(properties.getExposedHeaders());
        }
        if (properties.getMaxAge() != null) {
            configuration.setMaxAge(properties.getMaxAge());
        }
        if (properties.getAllowCredentials() != null) {
            configuration.setAllowCredentials(properties.getAllowCredentials());
        }
        return configuration;
    }

    @Bean
    @ConditionalOnMissingBean
    public MvcEndpoints mvcEndpoints() {
        return new MvcEndpoints();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={EnvironmentEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="env")
    public EnvironmentMvcEndpoint environmentMvcEndpoint(EnvironmentEndpoint delegate) {
        return new EnvironmentMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint(value="heapdump")
    public HeapdumpMvcEndpoint heapdumpMvcEndpoint() {
        return new HeapdumpMvcEndpoint();
    }

    @Bean
    @ConditionalOnBean(value={HealthEndpoint.class})
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint(value="health")
    public HealthMvcEndpoint healthMvcEndpoint(HealthEndpoint delegate, ManagementServerProperties managementServerProperties) {
        HealthMvcEndpoint healthMvcEndpoint = new HealthMvcEndpoint(delegate, this.managementServerProperties.getSecurity().isEnabled(), managementServerProperties.getSecurity().getRoles());
        if (this.healthMvcEndpointProperties.getMapping() != null) {
            healthMvcEndpoint.addStatusMapping(this.healthMvcEndpointProperties.getMapping());
        }
        return healthMvcEndpoint;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={LoggersEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="loggers")
    public LoggersMvcEndpoint loggersMvcEndpoint(LoggersEndpoint delegate) {
        return new LoggersMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MetricsEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="metrics")
    public MetricsMvcEndpoint metricsMvcEndpoint(MetricsEndpoint delegate) {
        return new MetricsMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint(value="logfile")
    @Conditional(value={LogFileCondition.class})
    public LogFileMvcEndpoint logfileMvcEndpoint() {
        return new LogFileMvcEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ShutdownEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="shutdown", enabledByDefault=false)
    public ShutdownMvcEndpoint shutdownMvcEndpoint(ShutdownEndpoint delegate) {
        return new ShutdownMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AuditEventRepository.class})
    @ConditionalOnEnabledEndpoint(value="auditevents")
    public AuditEventsMvcEndpoint auditEventMvcEndpoint(AuditEventRepository auditEventRepository) {
        return new AuditEventsMvcEndpoint(auditEventRepository);
    }

    private static class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            String config = environment.resolvePlaceholders("${logging.file:}");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Log File", (Object[])new Object[0]);
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.file").items(new Object[]{config}));
            }
            config = environment.resolvePlaceholders("${logging.path:}");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.path").items(new Object[]{config}));
            }
            config = new RelaxedPropertyResolver((PropertyResolver)environment, "endpoints.logfile.").getProperty("external-file");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("endpoints.logfile.external-file").items(new Object[]{config}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("logging file").atAll());
        }
    }
}

