/*
 * Copyright 2012-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.web.mappings.servlet;

import org.springframework.web.servlet.DispatcherServlet;

/**
 * A description of a mapping known to a {@link DispatcherServlet}.
 *
 * @author Andy Wilkinson
 * @since 2.0.0
 */
public class DispatcherServletMappingDescription {

	private final String handler;

	private final String predicate;

	/**
	 * Creates a new {@code DispatcherServletMappingDescription} for the given
	 * {@code handler} that will receives requests that match the given {@code predicate}.
	 *
	 * @param predicate the predicate
	 * @param handler the handler
	 */
	public DispatcherServletMappingDescription(String predicate, String handler) {
		this.handler = handler;
		this.predicate = predicate;
	}

	/**
	 * Returns the handler for the described mapping.
	 * @return the handler
	 */
	public String getHandler() {
		return this.handler;
	}

	/**
	 * Returns the predicate for the described mapping.
	 * @return the predicate
	 */
	public String getPredicate() {
		return this.predicate;
	}

}
