/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
public class HealthEndpointWebExtension {
    private final HealthIndicator delegate;
    private final HealthStatusHttpMapper statusHttpMapper;
    private final boolean showDetails;

    public HealthEndpointWebExtension(HealthIndicator delegate, HealthStatusHttpMapper statusHttpMapper, boolean showDetails) {
        this.delegate = delegate;
        this.statusHttpMapper = statusHttpMapper;
        this.showDetails = showDetails;
    }

    @ReadOperation
    public WebEndpointResponse<Health> getHealth() {
        return this.getHealth(this.showDetails);
    }

    public WebEndpointResponse<Health> getHealth(boolean showDetails) {
        Health health = this.delegate.health();
        Integer status = this.statusHttpMapper.mapStatus(health.getStatus());
        if (!showDetails) {
            health = Health.status(health.getStatus()).build();
        }
        return new WebEndpointResponse<Health>(health, status);
    }
}

