/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import reactor.core.publisher.Mono;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
public class ReactiveHealthEndpointWebExtension {
    private final ReactiveHealthIndicator delegate;
    private final HealthStatusHttpMapper statusHttpMapper;
    private final boolean showDetails;

    public ReactiveHealthEndpointWebExtension(ReactiveHealthIndicator delegate, HealthStatusHttpMapper statusHttpMapper, boolean showDetails) {
        this.delegate = delegate;
        this.statusHttpMapper = statusHttpMapper;
        this.showDetails = showDetails;
    }

    @ReadOperation
    public Mono<WebEndpointResponse<Health>> health() {
        return this.health(this.showDetails);
    }

    public Mono<WebEndpointResponse<Health>> health(boolean showDetails) {
        return this.delegate.health().map(health -> {
            Integer status = this.statusHttpMapper.mapStatus(health.getStatus());
            if (!showDetails) {
                health = Health.status(health.getStatus()).build();
            }
            return new WebEndpointResponse<Health>((Health)health, status);
        });
    }
}

