/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.integration;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;

public class SpringIntegrationMetrics
implements MeterBinder,
SmartInitializingSingleton {
    private final Tags tags;
    private Collection<MeterRegistry> registries = new ArrayList<MeterRegistry>();
    private final IntegrationManagementConfigurer configurer;

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer) {
        this(configurer, Collections.emptyList());
    }

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer, Iterable<? extends Tag> tags) {
        this.configurer = configurer;
        this.tags = Tags.of(tags);
    }

    public void bindTo(MeterRegistry registry) {
        this.registerGauge(registry, this.configurer, (Iterable<Tag>)this.tags, "spring.integration.channelNames", "The number of spring integration channels", configurer -> configurer.getChannelNames().length);
        this.registerGauge(registry, this.configurer, (Iterable<Tag>)this.tags, "spring.integration.handlerNames", "The number of spring integration handlers", configurer -> configurer.getHandlerNames().length);
        this.registerGauge(registry, this.configurer, (Iterable<Tag>)this.tags, "spring.integration.sourceNames", "The number of spring integration sources", configurer -> configurer.getSourceNames().length);
        this.registries.add(registry);
    }

    private void addSourceMetrics(MeterRegistry registry) {
        for (String source : this.configurer.getSourceNames()) {
            MessageSourceMetrics sourceMetrics = this.configurer.getSourceMetrics(source);
            Tags tagsWithSource = this.tags.and("source", source);
            this.registerFunctionCounter(registry, sourceMetrics, (Iterable<Tag>)tagsWithSource, "spring.integration.source.messages", "The number of successful handler calls", MessageSourceMetrics::getMessageCount);
        }
    }

    private void addHandlerMetrics(MeterRegistry registry) {
        for (String handler : this.configurer.getHandlerNames()) {
            MessageHandlerMetrics handlerMetrics = this.configurer.getHandlerMetrics(handler);
            Tags tagsWithHandler = this.tags.and("handler", handler);
            this.registerTimedGauge(registry, handlerMetrics, (Iterable<Tag>)tagsWithHandler, "spring.integration.handler.duration.max", "The maximum handler duration", MessageHandlerMetrics::getMaxDuration);
            this.registerTimedGauge(registry, handlerMetrics, (Iterable<Tag>)tagsWithHandler, "spring.integration.handler.duration.min", "The minimum handler duration", MessageHandlerMetrics::getMinDuration);
            this.registerTimedGauge(registry, handlerMetrics, (Iterable<Tag>)tagsWithHandler, "spring.integration.handler.duration.mean", "The mean handler duration", MessageHandlerMetrics::getMeanDuration);
            this.registerGauge(registry, handlerMetrics, (Iterable<Tag>)tagsWithHandler, "spring.integration.handler.activeCount", "The number of active handlers", MessageHandlerMetrics::getActiveCount);
        }
    }

    private void addChannelMetrics(MeterRegistry registry) {
        for (String channel : this.configurer.getChannelNames()) {
            MessageChannelMetrics channelMetrics = this.configurer.getChannelMetrics(channel);
            Tags tagsWithChannel = this.tags.and("channel", channel);
            this.registerFunctionCounter(registry, channelMetrics, (Iterable<Tag>)tagsWithChannel, "spring.integration.channel.sendErrors", "The number of failed sends (either throwing an exception or rejected by the channel)", MessageChannelMetrics::getSendErrorCount);
            this.registerFunctionCounter(registry, channelMetrics, (Iterable<Tag>)tagsWithChannel, "spring.integration.channel.sends", "The number of successful sends", MessageChannelMetrics::getSendCount);
            if (!(channelMetrics instanceof PollableChannelManagement)) continue;
            this.registerFunctionCounter(registry, (PollableChannelManagement)channelMetrics, (Iterable<Tag>)tagsWithChannel, "spring.integration.receives", "The number of messages received", PollableChannelManagement::getReceiveCount);
        }
    }

    private <T> void registerGauge(MeterRegistry registry, T object, Iterable<Tag> tags, String name, String description, ToDoubleFunction<T> value) {
        Gauge.Builder builder = Gauge.builder((String)name, object, value);
        builder.tags((Iterable)this.tags).description(description).register(registry);
    }

    private <T> void registerTimedGauge(MeterRegistry registry, T object, Iterable<Tag> tags, String name, String description, ToDoubleFunction<T> value) {
        TimeGauge.Builder builder = TimeGauge.builder((String)name, object, (TimeUnit)TimeUnit.MILLISECONDS, value);
        builder.tags(tags).description(description).register(registry);
    }

    private <T> void registerFunctionCounter(MeterRegistry registry, T object, Iterable<Tag> tags, String name, String description, ToDoubleFunction<T> value) {
        FunctionCounter.builder((String)name, object, value).tags(tags).description(description).register(registry);
    }

    public void afterSingletonsInstantiated() {
        this.registries.forEach(registry -> {
            this.addChannelMetrics((MeterRegistry)registry);
            this.addHandlerMetrics((MeterRegistry)registry);
            this.addSourceMetrics((MeterRegistry)registry);
        });
    }
}

