/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.trace.reactive;

import java.security.Principal;
import java.util.Set;
import org.springframework.boot.actuate.web.trace.HttpExchangeTracer;
import org.springframework.boot.actuate.web.trace.HttpTrace;
import org.springframework.boot.actuate.web.trace.HttpTraceRepository;
import org.springframework.boot.actuate.web.trace.Include;
import org.springframework.boot.actuate.web.trace.reactive.ServerWebExchangeTraceableRequest;
import org.springframework.boot.actuate.web.trace.reactive.TraceableServerHttpResponse;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class HttpTraceWebFilter
implements WebFilter,
Ordered {
    private static final Object NONE = new Object();
    private int order = 0x7FFFFFF5;
    private final HttpTraceRepository repository;
    private final HttpExchangeTracer tracer;
    private final Set<Include> includes;

    public HttpTraceWebFilter(HttpTraceRepository repository, HttpExchangeTracer tracer, Set<Include> includes) {
        this.repository = repository;
        this.tracer = tracer;
        this.includes = includes;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Mono principal = this.includes.contains((Object)Include.PRINCIPAL) ? exchange.getPrincipal().cast(Object.class).defaultIfEmpty(NONE) : Mono.just((Object)NONE);
        Mono session = this.includes.contains((Object)Include.SESSION_ID) ? exchange.getSession() : Mono.just((Object)NONE);
        return Mono.zip((Mono)principal, (Mono)session).flatMap(tuple -> this.filter(exchange, chain, this.asType(tuple.getT1(), Principal.class), this.asType(tuple.getT2(), WebSession.class)));
    }

    private <T> T asType(Object object, Class<T> type) {
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        return null;
    }

    private Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain, Principal principal, WebSession session) {
        ServerWebExchangeTraceableRequest request = new ServerWebExchangeTraceableRequest(exchange);
        HttpTrace trace = this.tracer.receivedRequest(request);
        return chain.filter(exchange).doAfterSuccessOrError((aVoid, ex) -> {
            this.tracer.sendingResponse(trace, new TraceableServerHttpResponse((ServerHttpResponse)(ex == null ? exchange.getResponse() : new CustomStatusResponseDecorator((Throwable)ex, exchange.getResponse()))), () -> principal, () -> this.getStartedSessionId(session));
            this.repository.add(trace);
        });
    }

    private String getStartedSessionId(WebSession session) {
        return session != null && session.isStarted() ? session.getId() : null;
    }

    private static final class CustomStatusResponseDecorator
    extends ServerHttpResponseDecorator {
        private final HttpStatus status;

        private CustomStatusResponseDecorator(Throwable ex, ServerHttpResponse delegate) {
            super(delegate);
            this.status = ex instanceof ResponseStatusException ? ((ResponseStatusException)ex).getStatus() : HttpStatus.INTERNAL_SERVER_ERROR;
        }

        public HttpStatus getStatusCode() {
            return this.status;
        }
    }
}

