/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthWebEndpointResponseMapper;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ShowDetails;
import reactor.core.publisher.Mono;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
public class ReactiveHealthEndpointWebExtension {
    private final ReactiveHealthIndicator delegate;
    private final HealthWebEndpointResponseMapper responseMapper;

    public ReactiveHealthEndpointWebExtension(ReactiveHealthIndicator delegate, HealthWebEndpointResponseMapper responseMapper) {
        this.delegate = delegate;
        this.responseMapper = responseMapper;
    }

    @ReadOperation
    public Mono<WebEndpointResponse<Health>> health(SecurityContext securityContext) {
        return this.delegate.health().map(health -> this.responseMapper.map((Health)health, securityContext));
    }

    public Mono<WebEndpointResponse<Health>> health(SecurityContext securityContext, ShowDetails showDetails) {
        return this.delegate.health().map(health -> this.responseMapper.map((Health)health, securityContext, showDetails));
    }
}

