/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CompositeReactiveHealthIndicator
implements ReactiveHealthIndicator {
    private final Map<String, ReactiveHealthIndicator> indicators;
    private final HealthAggregator healthAggregator;
    private Long timeout;
    private Health timeoutHealth;
    private final Function<Mono<Health>, Mono<Health>> timeoutCompose;

    public CompositeReactiveHealthIndicator(HealthAggregator healthAggregator) {
        this(healthAggregator, new LinkedHashMap<String, ReactiveHealthIndicator>());
    }

    public CompositeReactiveHealthIndicator(HealthAggregator healthAggregator, Map<String, ReactiveHealthIndicator> indicators) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        Assert.notNull(indicators, (String)"Indicators must not be null");
        this.indicators = new LinkedHashMap<String, ReactiveHealthIndicator>(indicators);
        this.healthAggregator = healthAggregator;
        this.timeoutCompose = mono -> this.timeout != null ? mono.timeout(Duration.ofMillis(this.timeout), Mono.just((Object)this.timeoutHealth)) : mono;
    }

    public CompositeReactiveHealthIndicator addHealthIndicator(String name, ReactiveHealthIndicator indicator) {
        this.indicators.put(name, indicator);
        return this;
    }

    public CompositeReactiveHealthIndicator timeoutStrategy(long timeout, Health timeoutHealth) {
        this.timeout = timeout;
        this.timeoutHealth = timeoutHealth != null ? timeoutHealth : Health.unknown().build();
        return this;
    }

    @Override
    public Mono<Health> health() {
        return Flux.fromIterable(this.indicators.entrySet()).flatMap(entry -> Mono.zip((Mono)Mono.just(entry.getKey()), (Mono)((ReactiveHealthIndicator)entry.getValue()).health().compose(this.timeoutCompose))).collectMap(Tuple2::getT1, Tuple2::getT2).map(this.healthAggregator::aggregate);
    }
}

