/*
 * Copyright 2012-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.info;

import org.springframework.boot.info.OsInfo;

/**
 * An {@link InfoContributor} that exposes {@link OsInfo}.
 *
 * @author Jonatan Ivanov
 * @since 2.7.0
 */
public class OsInfoContributor implements InfoContributor {

	private final OsInfo osInfo;

	public OsInfoContributor() {
		this.osInfo = new OsInfo();
	}

	@Override
	public void contribute(Info.Builder builder) {
		builder.withDetail("os", this.osInfo);
	}

}
