/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class PrometheusPushGatewayManager {
    private static final Log logger = LogFactory.getLog(PrometheusPushGatewayManager.class);
    private final PushGateway pushGateway;
    private final CollectorRegistry registry;
    private final String job;
    private final Map<String, String> groupingKey;
    private final ShutdownOperation shutdownOperation;
    private final TaskScheduler scheduler;
    private final ScheduledFuture<?> scheduled;

    public PrometheusPushGatewayManager(PushGateway pushGateway, CollectorRegistry registry, Duration pushRate, String job, Map<String, String> groupingKeys, ShutdownOperation shutdownOperation) {
        this(pushGateway, registry, (TaskScheduler)new PushGatewayTaskScheduler(), pushRate, job, groupingKeys, shutdownOperation);
    }

    public PrometheusPushGatewayManager(PushGateway pushGateway, CollectorRegistry registry, TaskScheduler scheduler, Duration pushRate, String job, Map<String, String> groupingKey, ShutdownOperation shutdownOperation) {
        Assert.notNull((Object)pushGateway, (String)"'pushGateway' must not be null");
        Assert.notNull((Object)registry, (String)"'registry' must not be null");
        Assert.notNull((Object)scheduler, (String)"'scheduler' must not be null");
        Assert.notNull((Object)pushRate, (String)"'pushRate' must not be null");
        Assert.hasLength((String)job, (String)"'job' must not be empty");
        this.pushGateway = pushGateway;
        this.registry = registry;
        this.job = job;
        this.groupingKey = groupingKey;
        this.shutdownOperation = shutdownOperation != null ? shutdownOperation : ShutdownOperation.NONE;
        this.scheduler = scheduler;
        this.scheduled = this.scheduler.scheduleAtFixedRate(this::post, pushRate);
    }

    private void post() {
        try {
            this.pushGateway.pushAdd(this.registry, this.job, this.groupingKey);
        }
        catch (Throwable ex) {
            logger.warn((Object)"Unexpected exception thrown by POST of metrics to Prometheus Pushgateway", ex);
        }
    }

    private void put() {
        try {
            this.pushGateway.push(this.registry, this.job, this.groupingKey);
        }
        catch (Throwable ex) {
            logger.warn((Object)"Unexpected exception thrown by PUT of metrics to Prometheus Pushgateway", ex);
        }
    }

    private void delete() {
        try {
            this.pushGateway.delete(this.job, this.groupingKey);
        }
        catch (Throwable ex) {
            logger.warn((Object)"Unexpected exception thrown by DELETE of metrics from Prometheus Pushgateway", ex);
        }
    }

    public void shutdown() {
        this.shutdown(this.shutdownOperation);
    }

    private void shutdown(ShutdownOperation shutdownOperation) {
        TaskScheduler taskScheduler = this.scheduler;
        if (taskScheduler instanceof PushGatewayTaskScheduler) {
            PushGatewayTaskScheduler pushGatewayTaskScheduler = (PushGatewayTaskScheduler)taskScheduler;
            pushGatewayTaskScheduler.shutdown();
        }
        this.scheduled.cancel(false);
        switch (shutdownOperation) {
            case POST: {
                this.post();
                break;
            }
            case PUT: {
                this.put();
                break;
            }
            case DELETE: {
                this.delete();
            }
        }
    }

    static class PushGatewayTaskScheduler
    extends ThreadPoolTaskScheduler {
        PushGatewayTaskScheduler() {
            this.setPoolSize(1);
            this.setDaemon(true);
            this.setThreadGroupName("prometheus-push-gateway");
        }

        public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
            return Executors.newSingleThreadScheduledExecutor(arg_0 -> ((PushGatewayTaskScheduler)this).newThread(arg_0));
        }
    }

    public static enum ShutdownOperation {
        NONE,
        POST,
        PUT,
        DELETE;

    }
}

