/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.util.Assert;

@FunctionalInterface
public interface SanitizingFunction {
    public SanitizableData apply(SanitizableData var1);

    default public Predicate<SanitizableData> filter() {
        return null;
    }

    default public SanitizableData applyUnlessFiltered(SanitizableData data) {
        return this.filter() == null || this.filter().test(data) ? this.apply(data) : data;
    }

    default public SanitizingFunction ifLikelySensitive() {
        return this.ifLikelyCredential().ifLikelyUri().ifLikelySensitiveProperty().ifVcapServices();
    }

    default public SanitizingFunction ifLikelyCredential() {
        return this.ifKeyEndsWith("password", "secret", "key", "token").ifKeyContains("credentials");
    }

    default public SanitizingFunction ifLikelyUri() {
        return this.ifKeyEndsWith("uri", "uris", "url", "urls", "address", "addresses");
    }

    default public SanitizingFunction ifLikelySensitiveProperty() {
        return this.ifKeyMatches("sun.java.command", "^spring[._]application[._]json$");
    }

    default public SanitizingFunction ifVcapServices() {
        return this.ifKeyEquals("vcap_services").ifKeyMatches("^vcap\\.services.*$");
    }

    default public SanitizingFunction ifKeyEquals(String ... values) {
        Assert.notNull((Object)values, (String)"'values' must not be null");
        return this.ifKeyMatchesIgnoringCase(String::equals, values);
    }

    default public SanitizingFunction ifKeyEndsWith(String ... suffixes) {
        Assert.notNull((Object)suffixes, (String)"'suffixes' must not be null");
        return this.ifKeyMatchesIgnoringCase(String::endsWith, suffixes);
    }

    default public SanitizingFunction ifKeyContains(String ... values) {
        Assert.notNull((Object)values, (String)"'values' must not be null");
        return this.ifKeyMatchesIgnoringCase(String::contains, values);
    }

    default public SanitizingFunction ifKeyMatchesIgnoringCase(BiPredicate<String, String> predicate, String ... values) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        Assert.notNull((Object)values, (String)"'values' must not be null");
        return this.ifMatches(Arrays.stream(values).map(value -> this.onKeyIgnoringCase(predicate, (String)value)).toList());
    }

    default public SanitizingFunction ifKeyMatches(String ... regexes) {
        Assert.notNull((Object)regexes, (String)"'regexes' must not be null");
        return this.ifKeyMatches((Pattern[])Arrays.stream(regexes).map(this::caseInsensitivePattern).toArray(Pattern[]::new));
    }

    default public SanitizingFunction ifKeyMatches(Pattern ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        return this.ifKeyMatches(Arrays.stream(patterns).map(Pattern::asMatchPredicate).toList());
    }

    default public SanitizingFunction ifKeyMatches(List<Predicate<String>> predicates) {
        Assert.notNull(predicates, (String)"'predicates' must not be null");
        return this.ifMatches(predicates.stream().map(this::onKey).toList());
    }

    default public SanitizingFunction ifKeyMatches(Predicate<String> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return this.ifMatches(this.onKey(predicate));
    }

    default public SanitizingFunction ifValueStringMatches(String ... regexes) {
        Assert.notNull((Object)regexes, (String)"'regexes' must not be null");
        return this.ifValueStringMatches((Pattern[])Arrays.stream(regexes).map(this::caseInsensitivePattern).toArray(Pattern[]::new));
    }

    default public SanitizingFunction ifValueStringMatches(Pattern ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        return this.ifValueStringMatches(Arrays.stream(patterns).map(Pattern::asMatchPredicate).toList());
    }

    default public SanitizingFunction ifValueStringMatches(List<Predicate<String>> predicates) {
        Assert.notNull(predicates, (String)"'predicates' must not be null");
        return this.ifMatches(predicates.stream().map(this::onValueString).toList());
    }

    default public SanitizingFunction ifValueMatches(List<Predicate<Object>> predicates) {
        Assert.notNull(predicates, (String)"'predicates' must not be null");
        return this.ifMatches(predicates.stream().map(this::onValue).toList());
    }

    default public SanitizingFunction ifValueStringMatches(Predicate<String> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return this.ifMatches(this.onValueString(predicate));
    }

    default public SanitizingFunction ifValueMatches(Predicate<Object> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return this.ifMatches((SanitizableData data) -> predicate.test(data.getValue()));
    }

    default public SanitizingFunction ifMatches(List<Predicate<SanitizableData>> predicates) {
        Assert.notNull(predicates, (String)"'predicates' must not be null");
        Predicate<SanitizableData> combined = null;
        for (Predicate<SanitizableData> predicate : predicates) {
            combined = combined != null ? combined.or(predicate) : predicate;
        }
        return this.ifMatches(combined);
    }

    default public SanitizingFunction ifMatches(Predicate<SanitizableData> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        final Predicate<SanitizableData> filter = this.filter() != null ? this.filter().or(predicate) : predicate;
        return new SanitizingFunction(){

            @Override
            public Predicate<SanitizableData> filter() {
                return filter;
            }

            @Override
            public SanitizableData apply(SanitizableData data) {
                return SanitizingFunction.this.apply(data);
            }
        };
    }

    private Pattern caseInsensitivePattern(String regex) {
        Assert.notNull((Object)regex, (String)"'regex' must not be null");
        return Pattern.compile(regex, 2);
    }

    private Predicate<SanitizableData> onKeyIgnoringCase(BiPredicate<String, String> predicate, String value) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        String lowerCaseValue = value.toLowerCase(Locale.getDefault());
        return data -> this.nullSafeTest(data.getLowerCaseKey(), lowerCaseKey -> predicate.test((String)lowerCaseKey, lowerCaseValue));
    }

    private Predicate<SanitizableData> onKey(Predicate<String> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return data -> this.nullSafeTest(data.getKey(), predicate);
    }

    private Predicate<SanitizableData> onValue(Predicate<Object> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return data -> this.nullSafeTest(data.getValue(), predicate);
    }

    private Predicate<SanitizableData> onValueString(Predicate<String> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        return data -> this.nullSafeTest(data.getValue() != null ? data.getValue().toString() : null, predicate);
    }

    private <T> boolean nullSafeTest(T value, Predicate<T> predicate) {
        return value != null && predicate.test(value);
    }

    public static SanitizingFunction sanitizeValue() {
        return SanitizableData::withSanitizedValue;
    }

    public static SanitizingFunction of(SanitizingFunction sanitizingFunction) {
        Assert.notNull((Object)sanitizingFunction, (String)"'sanitizingFunction' must not be null");
        return sanitizingFunction;
    }
}

