/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.beans;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

@Endpoint(id="beans")
public class BeansEndpoint {
    private final ConfigurableApplicationContext context;

    public BeansEndpoint(ConfigurableApplicationContext context) {
        this.context = context;
    }

    @ReadOperation
    public BeansDescriptor beans() {
        HashMap<String, ContextBeansDescriptor> contexts = new HashMap<String, ContextBeansDescriptor>();
        ConfigurableApplicationContext context = this.context;
        while (context != null) {
            contexts.put(context.getId(), ContextBeansDescriptor.describing(context));
            context = BeansEndpoint.getConfigurableParent(context);
        }
        return new BeansDescriptor(contexts);
    }

    private static @Nullable ConfigurableApplicationContext getConfigurableParent(ConfigurableApplicationContext context) {
        ApplicationContext parent = context.getParent();
        if (parent instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableParent = (ConfigurableApplicationContext)parent;
            return configurableParent;
        }
        return null;
    }

    public static final class ContextBeansDescriptor {
        private final Map<String, BeanDescriptor> beans;
        private final @Nullable String parentId;

        private ContextBeansDescriptor(Map<String, BeanDescriptor> beans, @Nullable String parentId) {
            this.beans = beans;
            this.parentId = parentId;
        }

        public @Nullable String getParentId() {
            return this.parentId;
        }

        public Map<String, BeanDescriptor> getBeans() {
            return this.beans;
        }

        private static @Nullable ContextBeansDescriptor describing(@Nullable ConfigurableApplicationContext context) {
            if (context == null) {
                return null;
            }
            ConfigurableApplicationContext parent = BeansEndpoint.getConfigurableParent(context);
            return new ContextBeansDescriptor(ContextBeansDescriptor.describeBeans(context.getBeanFactory()), parent != null ? parent.getId() : null);
        }

        private static Map<String, BeanDescriptor> describeBeans(ConfigurableListableBeanFactory beanFactory) {
            HashMap<String, BeanDescriptor> beans = new HashMap<String, BeanDescriptor>();
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
                if (!ContextBeansDescriptor.isBeanEligible(beanName, definition, (ConfigurableBeanFactory)beanFactory)) continue;
                beans.put(beanName, ContextBeansDescriptor.describeBean(beanName, definition, beanFactory));
            }
            return beans;
        }

        private static BeanDescriptor describeBean(String name, BeanDefinition definition, ConfigurableListableBeanFactory factory) {
            return new BeanDescriptor(factory.getAliases(name), definition.getScope(), factory.getType(name), definition.getResourceDescription(), factory.getDependenciesForBean(name));
        }

        private static boolean isBeanEligible(String beanName, BeanDefinition bd, ConfigurableBeanFactory bf) {
            return bd.getRole() != 2 && (!bd.isLazyInit() || bf.containsSingleton(beanName));
        }
    }

    public static final class BeansDescriptor
    implements OperationResponseBody {
        private final Map<String, ContextBeansDescriptor> contexts;

        private BeansDescriptor(Map<String, ContextBeansDescriptor> contexts) {
            this.contexts = contexts;
        }

        public Map<String, ContextBeansDescriptor> getContexts() {
            return this.contexts;
        }
    }

    public static final class BeanDescriptor {
        private final String[] aliases;
        private final @Nullable String scope;
        private final @Nullable Class<?> type;
        private final @Nullable String resource;
        private final String[] dependencies;

        private BeanDescriptor(String[] aliases, @Nullable String scope, @Nullable Class<?> type, @Nullable String resource, String[] dependencies) {
            this.aliases = aliases;
            this.scope = StringUtils.hasText((String)scope) ? scope : "singleton";
            this.type = type;
            this.resource = resource;
            this.dependencies = dependencies;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public @Nullable String getScope() {
            return this.scope;
        }

        public @Nullable Class<?> getType() {
            return this.type;
        }

        public @Nullable String getResource() {
            return this.resource;
        }

        public String[] getDependencies() {
            return this.dependencies;
        }
    }
}

