/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Locale;
import java.util.function.Predicate;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameters;
import org.springframework.boot.actuate.endpoint.invoke.reflect.OperationMethodParameters;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

public class OperationMethod {
    private static final ParameterNameDiscoverer DEFAULT_PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Method method;
    private final OperationType operationType;
    private final OperationParameters operationParameters;

    @Deprecated(since="4.0.0", forRemoval=true)
    public OperationMethod(Method method, OperationType operationType) {
        this(method, operationType, parameter -> false);
    }

    public OperationMethod(Method method, OperationType operationType, Predicate<Parameter> optionalParameters) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        Assert.notNull((Object)((Object)operationType), (String)"'operationType' must not be null");
        this.method = method;
        this.operationType = operationType;
        this.operationParameters = new OperationMethodParameters(method, DEFAULT_PARAMETER_NAME_DISCOVERER, optionalParameters);
    }

    public Method getMethod() {
        return this.method;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public OperationParameters getParameters() {
        return this.operationParameters;
    }

    public String toString() {
        return "Operation " + this.operationType.name().toLowerCase(Locale.ENGLISH) + " method " + String.valueOf(this.method);
    }
}

