/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Contributor;
import org.springframework.boot.actuate.health.HealthDescriptor;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointSupport;
import org.springframework.boot.actuate.health.HealthEndpointWebExtensionRuntimeHints;
import org.springframework.boot.actuate.health.IndicatedHealthDescriptor;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;
import org.springframework.context.annotation.ImportRuntimeHints;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
@ImportRuntimeHints(value={HealthEndpointWebExtensionRuntimeHints.class})
public class HealthEndpointWebExtension
extends HealthEndpointSupport<Health, HealthDescriptor> {
    public HealthEndpointWebExtension(HealthContributorRegistry registry, @Nullable ReactiveHealthContributorRegistry fallbackRegistry, HealthEndpointGroups groups, @Nullable Duration slowContributorLoggingThreshold) {
        super(Contributor.blocking(registry, fallbackRegistry), groups, slowContributorLoggingThreshold);
    }

    @ReadOperation
    public WebEndpointResponse<HealthDescriptor> health(ApiVersion apiVersion, WebServerNamespace serverNamespace, SecurityContext securityContext) {
        return this.health(apiVersion, serverNamespace, securityContext, false, EMPTY_PATH);
    }

    @ReadOperation
    public WebEndpointResponse<HealthDescriptor> health(ApiVersion apiVersion, WebServerNamespace serverNamespace, SecurityContext securityContext, String ... path) {
        return this.health(apiVersion, serverNamespace, securityContext, false, path);
    }

    public WebEndpointResponse<HealthDescriptor> health(ApiVersion apiVersion, @Nullable WebServerNamespace serverNamespace, SecurityContext securityContext, boolean showAll, String ... path) {
        HealthEndpointSupport.Result result = this.getResult(apiVersion, serverNamespace, securityContext, showAll, path);
        if (result == null) {
            return Arrays.equals(path, EMPTY_PATH) ? new WebEndpointResponse<HealthDescriptor>(IndicatedHealthDescriptor.UP, 200) : new WebEndpointResponse(404);
        }
        HealthDescriptor descriptor = (HealthDescriptor)result.descriptor();
        HealthEndpointGroup group = result.group();
        int statusCode = group.getHttpCodeStatusMapper().getStatusCode(descriptor.getStatus());
        return new WebEndpointResponse<HealthDescriptor>(descriptor, statusCode);
    }

    @Override
    protected HealthDescriptor aggregateDescriptors(ApiVersion apiVersion, Map<String, HealthDescriptor> contributions, StatusAggregator statusAggregator, boolean showComponents, @Nullable Set<String> groupNames) {
        return this.getCompositeDescriptor(apiVersion, contributions, statusAggregator, showComponents, groupNames);
    }
}

