/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.security;

import java.util.LinkedHashMap;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.security.authorization.event.AuthorizationDeniedEvent;
import org.springframework.security.authorization.event.AuthorizationEvent;
import org.springframework.security.core.Authentication;

public class AuthorizationAuditListener
extends AbstractAuthorizationAuditListener {
    public static final String AUTHORIZATION_FAILURE = "AUTHORIZATION_FAILURE";

    public void onApplicationEvent(AuthorizationEvent event) {
        if (event instanceof AuthorizationDeniedEvent) {
            AuthorizationDeniedEvent authorizationDeniedEvent = (AuthorizationDeniedEvent)event;
            this.onAuthorizationDeniedEvent(authorizationDeniedEvent);
        }
    }

    private void onAuthorizationDeniedEvent(AuthorizationDeniedEvent<?> event) {
        String name = this.getName(event.getAuthentication());
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Object details = this.getDetails(event.getAuthentication());
        if (details != null) {
            data.put("details", details);
        }
        this.publish(new AuditEvent(name, AUTHORIZATION_FAILURE, data));
    }

    private String getName(Supplier<Authentication> authentication) {
        try {
            return authentication.get().getName();
        }
        catch (Exception ex) {
            return "<unknown>";
        }
    }

    private @Nullable Object getDetails(Supplier<Authentication> authentication) {
        try {
            return authentication.get().getDetails();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

