/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jmx;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.util.ObjectUtils;

public class ParentAwareNamingStrategy
extends MetadataNamingStrategy
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private boolean ensureUniqueRuntimeObjectNames = false;

    public ParentAwareNamingStrategy(JmxAttributeSource attributeSource) {
        super(attributeSource);
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder(beanKey);
        if (this.parentContextContainsSameBean(this.applicationContext, beanKey)) {
            builder.append(",context=" + ObjectUtils.getIdentityHexString((Object)this.applicationContext));
        }
        if (this.ensureUniqueRuntimeObjectNames) {
            builder.append(",identity=" + ObjectUtils.getIdentityHexString((Object)managedBean));
        }
        ObjectName name = super.getObjectName(managedBean, beanKey);
        return name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private boolean parentContextContainsSameBean(ApplicationContext applicationContext, String beanKey) {
        if (applicationContext.getParent() != null) {
            try {
                this.applicationContext.getParent().getBean(beanKey);
                return true;
            }
            catch (BeansException ex) {
                return this.parentContextContainsSameBean(applicationContext.getParent(), beanKey);
            }
        }
        return false;
    }
}

