/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class})
@Order(value=-2147483648)
@Conditional(value={ResourceBundleCondition.class})
@EnableConfigurationProperties
@ConfigurationProperties(prefix="spring.messages")
public class MessageSourceAutoConfiguration {
    private static final Resource[] NO_RESOURCES = new Resource[0];
    private String basename = "messages";
    private String encoding = "utf-8";
    private int cacheSeconds = -1;

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        if (StringUtils.hasText((String)this.basename)) {
            messageSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.basename)));
        }
        messageSource.setDefaultEncoding(this.encoding);
        messageSource.setCacheSeconds(this.cacheSeconds);
        return messageSource;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    private static class ExtendedPathMatchingResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        private static final Log logger = LogFactory.getLog(PathMatchingResourcePatternResolver.class);
        private static final String JAR_FILE_EXTENSION = ".jar";
        private static final String JAR_URL_PREFIX = "jar:";

        public ExtendedPathMatchingResourcePatternResolver(ClassLoader classLoader) {
            super(classLoader);
        }

        protected Resource[] findAllClassPathResources(String location) throws IOException {
            String path = location;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ("".equals(path)) {
                LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
                result.addAll(Arrays.asList(super.findAllClassPathResources(location)));
                this.addAllClassLoaderJarRoots(this.getClassLoader(), result);
                return result.toArray(new Resource[result.size()]);
            }
            return super.findAllClassPathResources(location);
        }

        private void addAllClassLoaderJarRoots(ClassLoader classLoader, Set<Resource> result) {
            block7: {
                if (classLoader != null) {
                    block6: {
                        if (classLoader instanceof URLClassLoader) {
                            try {
                                this.addAllClassLoaderJarUrls(((URLClassLoader)classLoader).getURLs(), result);
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block6;
                                logger.debug((Object)("Cannot introspect jar files since ClassLoader [" + classLoader + "] does not support 'getURLs()': " + ex));
                            }
                        }
                    }
                    try {
                        this.addAllClassLoaderJarRoots(classLoader.getParent(), result);
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)("Cannot introspect jar files in parent ClassLoader since [" + classLoader + "] does not support 'getParent()': " + ex));
                    }
                }
            }
        }

        private void addAllClassLoaderJarUrls(URL[] urls, Set<Resource> result) {
            for (URL url : urls) {
                if (!this.isJarFileUrl(url)) continue;
                try {
                    UrlResource jarResource = new UrlResource(JAR_URL_PREFIX + url.toString() + "!/");
                    if (!jarResource.exists()) continue;
                    result.add((Resource)jarResource);
                }
                catch (MalformedURLException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Cannot search for matching files underneath " + url + " because it cannot be accessed as a JAR"), (Throwable)ex);
                }
            }
        }

        private boolean isJarFileUrl(URL url) {
            return "file".equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
        }
    }

    protected static class ResourceBundleCondition
    extends SpringBootCondition {
        protected ResourceBundleCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String basename = context.getEnvironment().getProperty("spring.messages.basename", "messages");
            for (String name : StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)basename))) {
                for (Resource resource : this.getResources(context.getClassLoader(), name)) {
                    if (!resource.exists()) continue;
                    return ConditionOutcome.match("Bundle found for spring.messages.basename: " + name);
                }
            }
            return ConditionOutcome.noMatch("No bundle found for spring.messages.basename: " + basename);
        }

        private Resource[] getResources(ClassLoader classLoader, String name) {
            try {
                return new ExtendedPathMatchingResourcePatternResolver(classLoader).getResources("classpath*:" + name + "*.properties");
            }
            catch (IOException ex) {
                return NO_RESOURCES;
            }
        }
    }
}

